@extends('layouts.master')
@section('title', 'فواتير الخدمات')

@section('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <style>
        body {
            background: #08131f;
        }

        .card-flat {
            background: #0f2233;
            border-radius: 14px;
            border: 1px solid #1e3b4d;
            padding: 16px 18px;
            color: #eaf4ff;
        }

        .stat-card {
            border-radius: 14px;
            padding: 12px 10px;
            color: #eaf4ff;
            display: flex;
            flex-direction: column;
            gap: 4px;
        }

        .stat-title {
            font-size: 0.8rem;
            opacity: .9;
        }

        .stat-value {
            font-size: 1.4rem;
            font-weight: 700;
        }

        .stat-sub {
            font-size: 0.75rem;
            opacity: .8;
        }

        #serviceInvoicesTable thead th {
            text-align: center;
        }
    </style>
@endsection

@section('content')

    {{-- العنوان + زر إضافة --}}
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="fw-bold text-light">
            <i class="fas fa-file-medical me-2 text-success"></i>
            فواتير الخدمات
        </h3>
        <a href="{{ route('service-invoices.create') }}" class="btn btn-success px-4">
            <i class="fas fa-plus"></i> إضافة فاتورة
        </a>
    </div>

    {{-- كروت الإحصائيات --}}
    <div class="row g-3 mb-3">
        <div class="col-md-3 col-sm-6">
            <div class="stat-card" style="background: linear-gradient(135deg,#4b6cb7 0%,#182848 100%);">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="stat-title">إجمالي الفواتير</span>
                    <i class="fas fa-layer-group"></i>
                </div>
                <div class="stat-value">{{ $stats['count_all'] ?? 0 }}</div>
                <div class="stat-sub">كل فواتير الخدمات المسجلة</div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="stat-card" style="background: linear-gradient(135deg,#198754 0%,#28a745 100%);">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="stat-title">اليوم</span>
                    <i class="fas fa-calendar-day"></i>
                </div>
                <div class="stat-value">{{ $stats['count_today'] ?? 0 }}</div>
                <div class="stat-sub">فواتير منشأة اليوم</div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="stat-card" style="background: linear-gradient(135deg,#ffc107 0%,#ffb300 100%);">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="stat-title">هذا الشهر</span>
                    <i class="fas fa-calendar-alt"></i>
                </div>
                <div class="stat-value">{{ $stats['count_month'] ?? 0 }}</div>
                <div class="stat-sub">فواتير خلال الشهر الحالي</div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="stat-card" style="background: linear-gradient(135deg,#0d6efd 0%,#1f89ff 100%);">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="stat-title">إجمالي صافي الفواتير</span>
                    <i class="fas fa-coins"></i>
                </div>
                <div class="stat-value">{{ number_format($stats['sum_net'] ?? 0, 2) }}</div>
                <div class="stat-sub">إجمالي المبلغ بعد الخصم والضريبة</div>
            </div>
        </div>
    </div>

    {{-- فلاتر البحث --}}
    <div class="card-flat mb-3">
        <h6 class="mb-3">🔍 فلاتر البحث</h6>

        <div class="row g-3">
            <div class="col-md-3">
                <label class="form-label">الفرع</label>
                <select id="filter_branch" class="form-select">
                    <option value="">الكل</option>
                    @foreach ($branches as $b)
                        <option value="{{ $b->id }}">{{ $b->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-3">
                <label class="form-label">مقدم الخدمة</label>
                <select id="filter_provider" class="form-select">
                    <option value="">الكل</option>
                    @foreach ($providers as $u)
                        <option value="{{ $u->id }}">{{ $u->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-2">
                <label class="form-label">من تاريخ</label>
                <input type="date" id="filter_from" class="form-control">
            </div>

            <div class="col-md-2">
                <label class="form-label">إلى تاريخ</label>
                <input type="date" id="filter_to" class="form-control">
            </div>

            <div class="col-md-2">
                <label class="form-label">بحث نصي</label>
                <input type="text" id="searchBox" class="form-control" placeholder="رقم وثيقة / فاتورة / عضو">
            </div>
        </div>
    </div>

    {{-- جدول الفواتير --}}
    <div class="card-flat">
        <table id="serviceInvoicesTable"
            class="table table-dark table-striped table-bordered text-center align-middle mb-0">
            <thead>
                <tr>
                    <th>#</th>
                    <th>رقم الوثيقة</th>
                    <th>رقم الفاتورة</th>
                    <th>العضو</th>
                    <th>الفرع</th>
                    <th>مقدم الخدمة</th>
                    {{-- <th>التاريخ</th> --}}
                    <th>الصافي</th>
                    <th>إجراءات</th>
                </tr>
            </thead>
        </table>
    </div>
@endsection

@section('js')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

    <script>
        let table;
        $(function() {
            table = $('#serviceInvoicesTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('service-invoices.index') }}",
                    data: d => {
                        d.branch_id = $('#filter_branch').val();
                        d.provider_user_id = $('#filter_provider').val();
                        d.date_from = $('#filter_from').val();
                        d.date_to = $('#filter_to').val();
                        d.search_text = $('#searchBox').val();
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'document_no',
                        name: 'document_no'
                    },
                    {
                        data: 'invoice_no',
                        name: 'invoice_no'
                    },
                    {
                        data: 'member_name',
                        name: 'member.name'
                    },
                    {
                        data: 'branch_name',
                        name: 'branch.name'
                    },
                    {
                        data: 'provider_name',
                        name: 'provider.name'
                    },
                    // {
                    //     data: 'greg_date',
                    //     name: 'greg_date'
                    // },
                    {
                        data: 'total_net',
                        name: 'total_net',
                        render: v => `<span class="text-success fw-bold">${v}</span>`
                    },
                    {
                        data: 'actions',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ],
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.13.6/i18n/ar.json"
                }
            });

            $('#filter_branch, #filter_provider, #filter_from, #filter_to')
                .on('change', () => table.ajax.reload());

            $('#searchBox').on('keyup', function() {
                table.ajax.reload();
            });
        });
    </script>
@endsection
