@extends('layouts.master')
@section('title', 'Simplified Tax Invoice')

@section('css')
    <style>
        .invoice {
            padding: 40px 50px;
            border-radius: 8px;
            border: 1px solid #e3e3e3;
            max-width: 900px;
            margin: auto;
            box-shadow: 0 0 8px rgba(0, 0, 0, 0.05);
            color: #222;
        }

        .invoice-header {
            border-bottom: 2px solid #dee2e6;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }

        .invoice-header h3 {
            font-weight: 700;
            margin: 0;
        }

        .invoice-header small {
            color: #777;
        }

        .invoice-meta {
            font-size: 14px;
            color: #555;
        }

        .table th {
            background: #f9f9f9;
            color: #333;
            font-weight: 600;
            border-color: #e0e0e0 !important;
        }

        .table td {
            border-color: #e0e0e0 !important;
            vertical-align: middle !important;
        }

        .total-section {
            background: #f9f9f9;
            border-radius: 8px;
            padding: 15px;
            border: 1px solid #e0e0e0;
        }

        .total-section h5 {
            margin: 0;
            font-weight: 700;
            color: #198754;
        }

        .footer {
            text-align: center;
            font-size: 13px;
            color: #666;
            margin-top: 30px;
        }

        @media print {
            .no-print {
                display: none !important;
            }

            body {
                background: #fff;
            }

            .invoice {
                box-shadow: none;
                border: none;
                margin: 0;
                padding: 0;
            }
        }
    </style>
@endsection

@section('content')

    @php
        use App\Models\CompanySetting;

        $company = CompanySetting::first();

        $companyName = $company ? $company->getTranslation('name', app()->getLocale()) : '—';

        $vatNumber = $company->tax_number ?? '—';
    @endphp

    <div class="container my-4">
        <div class="invoice"
            style="padding:40px 50px;border:1px solid #e3e3e3;border-radius:8px;max-width:900px;margin:auto;color:#222;">

            {{-- HEADER --}}
            <div class="d-flex justify-content-between align-items-start"
                style="border-bottom:2px solid #dee2e6;padding-bottom:15px;margin-bottom:20px;">
                <div>
                    <h3 style="margin:0;font-weight:700;">فاتورة خدمات<br>
                        <small style="color:#777;">Service Invoice</small>
                    </h3>
                </div>
                <div class="text-end">
                    <div class="qrcode_box_{{ $serviceInvoice->id }}"></div>
                </div>
            </div>

            {{-- BASIC --}}
            <div class="row mb-4">
                <div class="col-md-6">
                    <p><strong>رقم الفاتورة:</strong> {{ $serviceInvoice->invoice_no }}</p>
                    <p><strong>Date / التاريخ:</strong> {{ $serviceInvoice->created_at->format('Y-m-d') }}</p>
                    <p><strong>العضو:</strong> {{ $serviceInvoice->member->name ?? '—' }}</p>
                </div>

                {{-- <div class="col-md-6 text-md-end">
                    <p><strong>الفرع:</strong> {{ $serviceInvoice->branch->name ?? '—' }}</p>
                </div> --}}
            </div>

            {{-- DATES --}}
            <div class="row mt-4 mb-3 text-center small bg-light rounded-3 py-3">
                <div class="col-md-6">
                    <b>📅 تاريخ تقديم الخدمة:</b> {{ $serviceInvoice->service_date->format('Y-m-d') }}
                </div>

                <div class="col-md-6">
                    <b>⏳ نهاية الخدمة:</b> {{ $serviceInvoice->end_date->format('Y-m-d') }}
                </div>
            </div>


            {{-- ITEMS --}}
            <table class="table table-bordered text-center align-middle">
                <thead>
                    <tr>
                        <th>الوصف</th>
                        <th>الكمية</th>
                        <th>السعر</th>
                        <th>الخصم</th>
                        <th>الصافي قبل الضريبة</th>
                        <th>الضريبة (15%)</th>
                        <th>الإجمالي</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($serviceInvoice->items as $item)
                        @php
                            $qty = $item->qty ?? 1;
                            $rowPrice = $qty * $item->price;
                            $rowNet = $rowPrice - $item->discount; // الصافي قبل الضريبة (بعد خصم الصف)
                        @endphp
                        <tr>
                            {{-- اسم الخدمة / العرض من عمود description --}}
                            <td>{{ $item->description }}</td>

                            <td>{{ $qty }}</td>

                            <td>{{ number_format($item->price, 2) }}</td>

                            <td>{{ number_format($item->discount, 2) }}</td>

                            {{-- الصافي قبل الضريبة --}}
                            <td>{{ number_format($rowNet, 2) }}</td>

                            <td>{{ number_format($item->tax, 2) }}</td>

                            <td class="fw-bold">{{ number_format($item->total, 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>


            {{-- PAYMENT METHODS --}}
            @php
                $payments = is_array($serviceInvoice->payment_methods)
                    ? $serviceInvoice->payment_methods
                    : json_decode($serviceInvoice->payment_methods, true);
            @endphp

            @if (!empty($payments))
                <h6 class="fw-bold mt-4 mb-2">💳 تفاصيل الدفع</h6>
                <table class="table table-bordered text-center table-sm align-middle">
                    <thead>
                        <tr>
                            <th>طريقة الدفع</th>
                            <th>المبلغ</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($payments as $p)
                            @php
                                // method = ID طريقة الدفع
                                $methodId = $p['method'] ?? null;
                                $method = $paymentMethods[$methodId] ?? null;
                            @endphp

                            <tr>
                                <td>
                                    {{ $method ? (app()->getLocale() === 'ar' ? $method->name_ar : $method->name_en) : '—' }}
                                </td>
                                <td>{{ number_format($p['amount'], 2) }}</td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
            @endif

            {{-- TOTALS BLOCK --}}
            @php
                // الصافي قبل الضريبة = الإجمالي النهائي - الضريبة النهائية
                $beforeTaxFinal = $serviceInvoice->total_net - $serviceInvoice->total_tax;
            @endphp

            <div class="mt-4">
                <table class="table table-bordered text-center align-middle" style="font-size:15px;">
                    <tr>
                        <th style="width:40%">إجمالي السعر قبل الخصومات</th>
                        <td>{{ number_format($serviceInvoice->total_price, 2) }}</td>
                    </tr>

                    <tr>
                        <th>إجمالي الخصومات (خصومات البنود + الخصم الإضافي)</th>
                        <td class="text-danger fw-bold">
                            {{ number_format($serviceInvoice->total_discount, 2) }}
                        </td>
                    </tr>

                    <tr>
                        <th>الصافي قبل الضريبة بعد جميع الخصومات</th>
                        <td class="text-info fw-bold">
                            {{ number_format($beforeTaxFinal, 2) }}
                        </td>
                    </tr>

                    <tr>
                        <th>إجمالي الضريبة (15%)</th>
                        <td class="text-warning fw-bold">
                            {{ number_format($serviceInvoice->total_tax, 2) }}
                        </td>
                    </tr>

                    <tr>
                        <th class="bg-light">الصافي النهائي شامل الضريبة</th>
                        <td class="bg-light text-success fw-bold" style="font-size:18px;">
                            {{ number_format($serviceInvoice->total_net, 2) }}
                        </td>
                    </tr>
                </table>
            </div>



            {{-- FOOTER --}}
            <div class="text-center mt-3" style="font-size:13px;color:#666;">
                شكراً لاختياركم خدمتنا ❤️<br>Thank you for choosing our service
            </div>

        </div>

        <div class="text-end mt-3 no-print">
            <button class="btn btn-primary" id="printBtn">
                🖨 طباعة الفاتورة
            </button>
        </div>
    </div>
@endsection

@section('js')

    <!-- مكتبة الطباعة -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/printThis/1.15.0/printThis.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {

            function toTLV(tag, value) {
                const textEncoder = new TextEncoder();
                const valueBytes = textEncoder.encode(value);
                return new Uint8Array([tag, valueBytes.length, ...valueBytes]);
            }

            const sellerName = @json($companyName);
            const vatNumber = @json($vatNumber);

            const date = "{{ $serviceInvoice->created_at->format('Y-m-d\\TH:i:s') }}";
            const total = "{{ number_format($serviceInvoice->total_net, 2, '.', '') }}";
            const vat = "{{ number_format($serviceInvoice->total_tax, 2, '.', '') }}";

            const tlv = [
                toTLV(1, sellerName),
                toTLV(2, vatNumber),
                toTLV(3, date),
                toTLV(4, total),
                toTLV(5, vat)
            ];

            const merged = new Uint8Array(tlv.flatMap(v => Array.from(v)));
            const base64 = btoa(String.fromCharCode(...merged));

            const qrUrl =
                `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(base64)}&size=130x130`;

            document.querySelector(".qrcode_box_{{ $serviceInvoice->id }}").innerHTML =
                `<img src="${qrUrl}" width="130" height="130"
                  style="border:1px solid #ddd;border-radius:8px;">`;

            // =============== PRINT ===============
            document.getElementById("printBtn").addEventListener("click", function() {
                $(".invoice").printThis({
                    importCSS: true,
                    importStyle: true,
                    printContainer: true,
                    pageTitle: "فاتورة خدمات",
                    removeInline: false,
                    printDelay: 300,
                });
            });

        });
    </script>


@endsection
