{{-- resources/views/admin/services/index.blade.php --}}
@extends('layouts.master')

@section('title', 'الخدمات')
@section('pages') {{ __('dashboard.home') }} @endsection

@section('btn')
    <a href="{{ route('services.create') }}" class="btn btn-outline-success">
        <i class="fas fa-plus-circle mx-2"></i> إضافة خدمة
    </a>
@endsection

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        #services-table th,
        #services-table td {
            text-align: center;
            vertical-align: middle;
        }

        .dataTables_processing {
            background: none !important;
            color: teal !important;
            font-weight: 700;
        }

        .badge-status {
            font-size: .85rem;
        }

        .filters .form-select,
        .filters .form-control {
            min-width: 180px
        }

        #services-table td .btn {
            padding: .25rem .5rem;
        }
    </style>
@endsection

@section('content')
    <div class="card p-3 mb-3">
        <div class="row g-2 align-items-end filters">
            <div class="col-md-3">
                <label class="form-label">الاسم</label>
                <input type="text" id="f_name" class="form-control" placeholder="بحث بالاسم...">
            </div>
            <div class="col-md-3">
                <label class="form-label">نوع الخدمة</label>
                <select id="f_type" class="form-select">
                    <option value="">— الكل —</option>
                    @foreach ($types as $t)
                        <option value="{{ $t->id }}">{{ $t->getTranslation('name', app()->getLocale()) }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">فئة الخدمة</label>
                <select id="f_category" class="form-select">
                    <option value="">— الكل —</option>
                    @foreach ($categories as $c)
                        <option value="{{ $c->id }}">{{ $c->getTranslation('name', app()->getLocale()) }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">الحالة</label>
                <select id="f_active" class="form-select">
                    <option value="">— الكل —</option>
                    <option value="1">نشط</option>
                    <option value="0">غير نشط</option>
                </select>
            </div>
            <div class="col-md-1 d-grid">
                <button id="f_reset" class="btn btn-secondary"><i class="fas fa-rotate-left"></i></button>
            </div>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered dataTable" id="services-table" style="width:100%">
            <thead>
                <tr>
                    <th>#</th>
                    <th>الاسم</th>
                    <th>النوع</th>
                    <th>الفئة</th>
                    <th>السعر</th>
                    <th>المدة</th>
                    <th>الحالة</th>
                    <th>إجراءات</th>
                </tr>
            </thead>
        </table>
    </div>
@endsection

@section('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const table = $('#services-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('services.index') }}",
                    data: function(d) {
                        d.name = $('#f_name').val() || '';
                        d.type_id = $('#f_type').val() || '';
                        d.category_id = $('#f_category').val() || '';
                        d.active = $('#f_active').val() || '';
                    }
                },
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'translated_name',
                        name: 'name'
                    },
                    {
                        data: 'type_name',
                        name: 'service_type_id'
                    },
                    {
                        data: 'category_name',
                        name: 'service_category_id'
                    },
                    {
                        data: 'price',
                        name: 'price'
                    },
                    {
                        data: 'duration_text',
                        name: 'duration_value'
                    },
                    {
                        data: 'active_badge',
                        name: 'active',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                order: [
                    [0, 'asc']
                ]
            });

            // فلاتر
            $('#f_name').on('keyup', debounce(() => table.ajax.reload(), 400));
            $('#f_type, #f_category, #f_active').on('change', () => table.ajax.reload());
            $('#f_reset').on('click', function() {
                $('#f_name').val('');
                $('#f_type').val('');
                $('#f_category').val('');
                $('#f_active').val('');
                table.ajax.reload();
            });

            function debounce(fn, delay) {
                let t;
                return function() {
                    clearTimeout(t);
                    t = setTimeout(fn, delay);
                };
            }
        });
    </script>
@endsection
