{{-- resources/views/admin/services/form.blade.php --}}
@extends('layouts.master')

@section('title', isset($service) ? 'تعديل خدمة' : 'إضافة خدمة')
@section('pages') {{ __('dashboard.home') }} @endsection

@section('css')
    <style>
        .card-section {
            background: #0f1e2b;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 16px
        }

        .card-section h6 {
            margin-bottom: 12px
        }

        .setting-body.disabled {
            opacity: .45;
            pointer-events: none;
            filter: grayscale(.4)
        }

        .tabs-sticky {
            position: sticky;
            top: 60px;
            z-index: 8;
            background: transparent
        }

        .tabs-sticky .nav-tabs {
            background: #0f1e2b;
            border-radius: 12px;
            padding: 6px
        }

        .header-row {
            gap: .75rem
        }

        @media (max-width:576px) {
            .header-row .btn {
                width: 100%
            }
        }

        .min-col-120 {
            min-width: 120px
        }
    </style>

    <style>
        .check-card {
            display: flex;
            align-items: center;
            gap: .6rem;
            border: 1px solid #203040;
            background: #0f1e2b;
            padding: .7rem .9rem;
            border-radius: 12px;
            cursor: pointer;
            transition: .15s ease;
        }

        .check-card:hover {
            border-color: #2a9db4;
            background: rgba(14, 165, 182, .08);
        }

        .check-card .form-check-input {
            width: 1.1rem;
            height: 1.1rem;
            cursor: pointer;
        }

        /* إبراز البلاطة عند الاختيار */
        .check-card input:checked+.label-text,
        .check-card input:checked~.label-text {
            font-weight: 600;
        }

        /* إخفاء عناصر الصف عند الفلترة */
        .branch-col[hidden] {
            display: none !important;
        }
    </style>

@endsection

@section('content')
    @php
        $isEdit = isset($service);
        $action = $isEdit ? route('services.update', $service) : route('services.store');
        $method = $isEdit ? 'PUT' : 'POST';
        $formatTime = function ($t) {
            if (!$t) {
                return '';
            }
            $p = explode(':', $t);
            return sprintf('%02d:%02d', (int) ($p[0] ?? 0), (int) ($p[1] ?? 0));
        };
        // كود الخدمة للعرض فقط (التوليد الفعلي في السيرفر)
        $serviceCodeDisplay = $isEdit ? $service->service_code ?? '-' : $suggestedServiceCode ?? '1001';

        // القيم القديمة/الافتراضية
        $oldSettings = old('settings', $isEdit ? $service->settings ?? [] : []);
        $daysAll = [
            'sat' => 'السبت',
            'sun' => 'الأحد',
            'mon' => 'الإثنين',
            'tue' => 'الثلاثاء',
            'wed' => 'الأربعاء',
            'thu' => 'الخميس',
            'fri' => 'الجمعة',
        ];
        $daysSelected = old(
            'days',
            $isEdit
                ? $service->days ?? ($oldSettings['days']['values'] ?? [])
                : ['sat', 'sun', 'mon', 'tue', 'wed', 'thu'], // افتراضيًا الكل عدا الجمعة
        );

        // فروع مقدِّمة/بائعة بالخانات المتكررة
        $providedOld = old('provided_branches', $isEdit ? $service->providedBranches->pluck('id')->all() : []);
        $soldOld = old('sold_branches', $isEdit ? $service->soldBranches->pluck('id')->all() : []);
        if (empty($providedOld)) {
            $providedOld = [null];
        }
        if (empty($soldOld)) {
            $soldOld = [null];
        }
    @endphp

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ $action }}" method="POST" id="serviceForm">
        @csrf @if ($isEdit)
            @method('PUT')
        @endif

        {{-- عنوان + أزرار --}}
        <div class="d-flex align-items-center justify-content-between flex-wrap header-row mb-3">
            <h5 class="mb-0"></h5>
            <div class="d-flex align-items-center gap-2">
                <button class="btn btn-primary"><i class="fas fa-save mx-2"></i>{{ $isEdit ? 'تحديث' : 'حفظ' }}</button>
                <a href="{{ route('services.index') }}" class="btn btn-secondary">{{ __('dashboard.back') }}</a>
            </div>
        </div>

        {{-- Tabs --}}
        <div class="tabs-sticky mb-3">
            <ul class="nav nav-tabs" id="serviceTabs" role="tablist">
                <li class="nav-item"><button class="nav-link active text-light" data-bs-toggle="tab"
                        data-bs-target="#tab-basic" type="button">البيانات الأساسية</button></li>
                {{-- <li class="nav-item"><button class="nav-link text-light" data-bs-toggle="tab" data-bs-target="#tab-days"
                        type="button">أيام الخدمة</button></li> --}}
                <li class="nav-item"><button class="nav-link text-light" data-bs-toggle="tab" data-bs-target="#tab-branches"
                        type="button">فروع الخدمة</button></li>
                <li class="nav-item"><button class="nav-link text-light" data-bs-toggle="tab" data-bs-target="#tab-settings"
                        type="button">إعدادات الخدمة</button></li>
            </ul>
        </div>

        <div class="tab-content">

            {{-- تبويب: البيانات الأساسية --}}
            <div class="tab-pane fade show active" id="tab-basic">
                <div class="card-section">
                    <h6>البيانات الأساسية</h6>
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">كود الخدمة</label>
                            <input type="text" class="form-control" value="{{ $serviceCodeDisplay }}" readonly>
                            @unless ($isEdit)
                            @endunless
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">نوع الخدمة <span class="text-danger">*</span></label>
                            <select name="service_type_id" class="form-select" required>
                                <option value="">—</option>
                                @foreach ($types as $t)
                                    <option value="{{ $t->id }}" @selected(old('service_type_id', $isEdit ? $service->service_type_id : null) == $t->id)>
                                        {{ $t->getTranslation('name', app()->getLocale()) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">فئة الخدمة <span class="text-danger">*</span></label>
                            <select name="service_category_id" class="form-select" required>
                                <option value="">—</option>
                                @foreach ($categories as $c)
                                    <option value="{{ $c->id }}" @selected(old('service_category_id', $isEdit ? $service->service_category_id : null) == $c->id)>
                                        {{ $c->getTranslation('name', app()->getLocale()) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">الحالة <span class="text-danger">*</span></label>
                            @php $activeOld = old('active', $isEdit? (int)$service->active : 1); @endphp
                            <select name="active" class="form-select" required>
                                <option value="1" @selected($activeOld == 1)>نشط</option>
                                <option value="0" @selected($activeOld == 0)>غير نشط</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">الاسم (ar) <span class="text-danger">*</span></label>
                            <input type="text" name="name[ar]" class="form-control"
                                value="{{ old('name.ar', $isEdit ? $service->getTranslation('name', 'ar') : '') }}"
                                required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">الاسم (en) <span class="text-danger">*</span></label>
                            <input type="text" name="name[en]" class="form-control"
                                value="{{ old('name.en', $isEdit ? $service->getTranslation('name', 'en') : '') }}"
                                required>
                        </div>






                        <div class="col-md-4">
                            <label class="form-label">السعر <span class="text-danger">*</span></label>
                            <input type="number" name="price" step="0.01" min="0" class="form-control"
                                value="{{ old('price', $isEdit ? $service->price : '') }}" required>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">نوع المدة <span class="text-danger">*</span></label>
                            @php $du = old('duration_unit', $isEdit? $service->duration_unit : 'days'); @endphp
                            <select name="duration_unit" class="form-select" required>
                                <option value="days" @selected($du === 'days')>أيام</option>
                                <option value="months" @selected($du === 'months')>شهور</option>
                                <option value="years" @selected($du === 'years')>سنوات</option>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">المدة <span class="text-danger">*</span></label>
                            <input type="number" name="duration_value" min="1" class="form-control"
                                value="{{ old('duration_value', $isEdit ? $service->duration_value : 1) }}" required>
                        </div>


                        <div class="col-md-6">
                            <label class="form-label">وقت البدء</label>
                            <input type="time" step="60" name="start_time" class="form-control"
                                value="{{ old('start_time', $isEdit ? $formatTime($service->start_time) : '') }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">وقت الانتهاء</label>
                            <input type="time" step="60" name="end_time" class="form-control"
                                value="{{ old('end_time', $isEdit ? $formatTime($service->end_time) : '') }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">ملاحظات (en)</label>
                            <textarea name="notes[en]" rows="3" class="form-control">{{ old('notes.en', $isEdit ? $service->getTranslation('notes', 'en') ?? '' : '') }}</textarea>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">ملاحظات (ar)</label>
                            <textarea name="notes[ar]" rows="3" class="form-control">{{ old('notes.ar', $isEdit ? $service->getTranslation('notes', 'ar') ?? '' : '') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            {{-- تبويب: أيام الخدمة (خارج الإعدادات) --}}
            <div class="tab-pane fade" id="tab-days">

            </div>
            {{-- تبويب: فروع الخدمة (مُقدِّمة/بائعة) --}}
            <div class="tab-pane fade" id="tab-branches">
                @php
                    // تأكيد وجود المصفوفتين (في حال مش متعرفين فوق)
                    $providedOld =
                        $providedOld ??
                        old('provided_branches', isset($service) ? $service->providedBranches->pluck('id')->all() : []);
                    $soldOld =
                        $soldOld ??
                        old('sold_branches', isset($service) ? $service->soldBranches->pluck('id')->all() : []);
                    $locale = app()->getLocale();
                @endphp

                {{-- الفروع المُقدِّمة --}}
                <div class="card-section mb-3">
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-2">
                        <h6 class="mb-0">الفروع المُقدِّمة للخدمة</h6>
                        <div class="d-flex align-items-center justify-content-around  gap-2">
                            <input type="search" class="form-control form-control-sm" id="providedSearch"
                                placeholder="ابحث عن فرع...">
                            <button type="button" class="btn btn-outline-primary btn-sm"
                                id="providedSelectVisible">تحديد الكل</button>
                            <button type="button" class="btn btn-outline-secondary btn-sm"
                                id="providedClearVisible">إلغاء تحديد الكل</button>
                            <span class="badge bg-info" id="providedCount">0 محدد</span>
                        </div>
                    </div>

                    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4 g-2" id="providedGrid">
                        @foreach ($branches as $b)
                            @php $bName = method_exists($b,'getTranslation') ? $b->getTranslation('name',$locale) : $b->name; @endphp
                            <div class="col branch-col" data-name="{{ Str::of($bName)->lower() }}">
                                <label class="check-card w-100">
                                    <input type="checkbox" class="form-check-input me-2 provided-item"
                                        id="prov_{{ $b->id }}" name="provided_branches[]"
                                        value="{{ $b->id }}" @checked(in_array($b->id, $providedOld))>
                                    <span class="label-text">{{ $bName }}</span>
                                </label>
                            </div>
                        @endforeach
                    </div>
                </div>

                {{-- الفروع البائعة --}}
                <div class="card-section">
                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-2">
                        <h6 class="mb-0">الفروع بائعة الخدمة</h6>
                        <div class="d-flex align-items-center gap-2">
                            <input type="search" class="form-control form-control-sm" id="soldSearch"
                                placeholder="ابحث عن فرع...">
                            <button type="button" class="btn btn-outline-primary btn-sm" id="soldSelectVisible">تحديد
                                الكل</button>
                            <button type="button" class="btn btn-outline-secondary btn-sm" id="soldClearVisible">إلغاء
                                تحديد الكل</button>
                            <span class="badge bg-info" id="soldCount">0 محدد</span>
                        </div>
                    </div>

                    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4 g-2" id="soldGrid">
                        @foreach ($branches as $b)
                            @php $bName = method_exists($b,'getTranslation') ? $b->getTranslation('name',$locale) : $b->name; @endphp
                            <div class="col branch-col" data-name="{{ Str::of($bName)->lower() }}">
                                <label class="check-card w-100">
                                    <input type="checkbox" class="form-check-input me-2 sold-item"
                                        id="sold_{{ $b->id }}" name="sold_branches[]"
                                        value="{{ $b->id }}" @checked(in_array($b->id, $soldOld))>
                                    <span class="label-text">{{ $bName }}</span>
                                </label>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            {{-- تبويب: إعدادات الخدمة --}}
            <div class="tab-pane fade" id="tab-settings">
                <div class="card-section">
                    <h6>إعدادات الخدمة (اختيارية)</h6>

                    {{-- إيقاف --}}
                    @php $pause = $oldSettings['pause'] ?? []; @endphp
                    <div class="border rounded p-3 mb-3">
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input setting-toggle" type="checkbox" id="toggle_pause"
                                name="settings[pause][enabled]" value="1" @checked(old('settings.pause.enabled', $pause['enabled'] ?? false))>
                            <label class="form-check-label fw-bold mx-2" for="toggle_pause">إمكانية الإيقاف</label>
                        </div>
                        <div class="row g-2 setting-body" data-for="toggle_pause">
                            <div class="col-md-4">
                                <label class="form-label">عدد مرات الإيقاف *</label>
                                <input type="number" min="1" class="form-control" required
                                    name="settings[pause][max_times]"
                                    value="{{ old('settings.pause.max_times', $pause['max_times'] ?? '') }}">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">أقصى مدة للإيقاف *</label>
                                <input type="number" min="1" class="form-control" required
                                    name="settings[pause][max_duration_value]"
                                    value="{{ old('settings.pause.max_duration_value', $pause['max_duration_value'] ?? '') }}">
                            </div>
                            @php $pdu = old('settings.pause.max_duration_unit', $pause['max_duration_unit'] ?? 'days'); @endphp
                            <div class="col-md-4">
                                <label class="form-label">وحدة المدة *</label>
                                <select class="form-select" name="settings[pause][max_duration_unit]" required>
                                    <option value="days" @selected($pdu === 'days')>أيام</option>
                                    <option value="months" @selected($pdu === 'months')>شهور</option>
                                    <option value="years" @selected($pdu === 'years')>سنوات</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    {{-- تنازل --}}
                    @php $tr = $oldSettings['transfer'] ?? []; @endphp
                    <div class="border rounded p-3 mb-3">
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input setting-toggle" type="checkbox" id="toggle_transfer"
                                name="settings[transfer][enabled]" value="1" @checked(old('settings.transfer.enabled', $tr['enabled'] ?? false))>
                            <label class="form-check-label fw-bold mx-2" for="toggle_transfer">إمكانية التنازل</label>
                        </div>
                        <div class="row g-2 setting-body" data-for="toggle_transfer">
                            <div class="col-md-4">
                                <label class="form-label">أقل مدة للتنازل *</label>
                                <input type="number" min="0" class="form-control" required
                                    name="settings[transfer][min_duration_value]"
                                    value="{{ old('settings.transfer.min_duration_value', $tr['min_duration_value'] ?? '') }}">
                            </div>
                            @php $tdu = old('settings.transfer.min_duration_unit', $tr['min_duration_unit'] ?? 'days'); @endphp
                            <div class="col-md-4">
                                <label class="form-label">وحدة المدة *</label>
                                <select class="form-select" name="settings[transfer][min_duration_unit]" required>
                                    <option value="days" @selected($tdu === 'days')>أيام</option>
                                    <option value="months" @selected($tdu === 'months')>شهور</option>
                                    <option value="years" @selected($tdu === 'years')>سنوات</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">رسوم التنازل *</label>
                                <input type="number" min="0" step="0.01" class="form-control" required
                                    name="settings[transfer][fee]"
                                    value="{{ old('settings.transfer.fee', $tr['fee'] ?? '') }}">
                            </div>
                        </div>
                    </div>

                    {{-- تجديد --}}
                    @php $rn = $oldSettings['renew'] ?? []; @endphp
                    <div class="border rounded p-3 mb-3">
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input setting-toggle" type="checkbox" id="toggle_renew"
                                name="settings[renew][enabled]" value="1" @checked(old('settings.renew.enabled', $rn['enabled'] ?? false))>
                            <label class="form-check-label fw-bold mx-2" for="toggle_renew">إمكانية التجديد</label>
                        </div>
                        <div class="row g-2 setting-body" data-for="toggle_renew">
                            <div class="col-md-4">
                                <label class="form-label">خدمة التجديد *</label>
                                <select class="form-select" name="settings[renew][with_service_id]" required>
                                    <option value="">— اختر —</option>
                                    @foreach ($allServices as $s)
                                        <option value="{{ $s->id }}" @selected(old('settings.renew.with_service_id', $rn['with_service_id'] ?? null) == $s->id)>
                                            {{ $s->getTranslation('name', app()->getLocale()) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">مدة إضافية *</label>
                                <input type="number" min="0" class="form-control" required
                                    name="settings[renew][extra_duration_value]"
                                    value="{{ old('settings.renew.extra_duration_value', $rn['extra_duration_value'] ?? '') }}">
                            </div>
                            @php $re = old('settings.renew.extra_duration_unit', $rn['extra_duration_unit'] ?? 'days'); @endphp
                            <div class="col-md-4">
                                <label class="form-label">وحدة *</label>
                                <select class="form-select" name="settings[renew][extra_duration_unit]" required>
                                    <option value="days" @selected($re === 'days')>أيام</option>
                                    <option value="months" @selected($re === 'months')>شهور</option>
                                    <option value="years" @selected($re === 'years')>سنوات</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">أقصى مدة *</label>
                                <input type="number" min="0" class="form-control" required
                                    name="settings[renew][max_duration_value]"
                                    value="{{ old('settings.renew.max_duration_value', $rn['max_duration_value'] ?? '') }}">
                            </div>
                            @php $rmx = old('settings.renew.max_duration_unit', $rn['max_duration_unit'] ?? 'days'); @endphp
                            <div class="col-md-4">
                                <label class="form-label">وحدة *</label>
                                <select class="form-select" name="settings[renew][max_duration_unit]" required>
                                    <option value="days" @selected($rmx === 'days')>أيام</option>
                                    <option value="months" @selected($rmx === 'months')>شهور</option>
                                    <option value="years" @selected($rmx === 'years')>سنوات</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    {{-- استرجاع --}}
                    @php $rf = $oldSettings['refund'] ?? []; @endphp
                    <div class="border rounded p-3">
                        <div class="form-check form-switch mb-2">
                            <input class="form-check-input setting-toggle" type="checkbox" id="toggle_refund"
                                name="settings[refund][enabled]" value="1" @checked(old('settings.refund.enabled', $rf['enabled'] ?? false))>
                            <label class="form-check-label fw-bold mx-2" for="toggle_refund">إمكانية الاسترجاع</label>
                        </div>
                        <div class="row g-2 setting-body" data-for="toggle_refund">
                            @php $rmth = old('settings.refund.method', $rf['method'] ?? 'money'); @endphp
                            <div class="col-md-4">
                                <label class="form-label">طريقة الاسترجاع *</label>
                                <select class="form-select" name="settings[refund][method]" id="refund_method" required>
                                    <option value="money" @selected($rmth === 'money')>مالي</option>
                                    <option value="points" @selected($rmth === 'points')>نقاط</option>
                                    <option value="exchange"@selected($rmth === 'exchange')>استبدال بخدمة</option>
                                </select>
                            </div>
                            <div class="col-md-8" id="refund_exchange_wrap">
                                <label class="form-label">الخدمة البديلة *</label>
                                <select class="form-select" name="settings[refund][exchange_service_id]" required>
                                    <option value="">— اختر —</option>
                                    @foreach ($allServices as $s)
                                        <option value="{{ $s->id }}" @selected(old('settings.refund.exchange_service_id', $rf['exchange_service_id'] ?? null) == $s->id)>
                                            {{ $s->getTranslation('name', app()->getLocale()) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>


                    <div class="card-section border rounded my-2 ">
                        <h6>أيام تقديم الخدمة</h6>
                        <div class="d-flex flex-wrap gap-3">
                            @foreach ($daysAll as $k => $label)
                                <div class="form-check min-col-120">
                                    <input class="form-check-input" type="checkbox" name="days[]"
                                        id="day_{{ $k }}" value="{{ $k }}"
                                        @checked(in_array($k, $daysSelected ?? []))>
                                    <label class="form-check-label"
                                        for="day_{{ $k }}">{{ $label }}</label>
                                </div>
                            @endforeach
                        </div>

                    </div>

                </div>
            </div>

        </div> {{-- /tab-content --}}



    </form>
@endsection

@section('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // حفظ آخر تبويب
            const tabs = document.querySelectorAll('#serviceTabs [data-bs-toggle="tab"]');
            const key = 'service_form_active_tab';
            const last = localStorage.getItem(key);
            if (last) {
                const t = document.querySelector(`#serviceTabs [data-bs-target="${last}"]`);
                if (t) new bootstrap.Tab(t).show();
            }
            tabs.forEach(btn => btn.addEventListener('shown.bs.tab', e => localStorage.setItem(key, e.target.dataset
                .bsTarget)));

            // ========== الإعدادات (تمكين/تعطيل) ==========
            function clearInput(el) {
                const t = (el.getAttribute('type') || '').toLowerCase();
                if (t === 'checkbox' || t === 'radio') {
                    el.checked = false;
                } else {
                    el.value = '';
                }
            }

            function refreshRefundUI(on) {
                const wrap = document.getElementById('refund_exchange_wrap');
                const sel = wrap?.querySelector('[name="settings[refund][exchange_service_id]"]');
                const mSel = document.getElementById('refund_method');
                const show = on && mSel && mSel.value === 'exchange';
                if (wrap) {
                    wrap.style.display = show ? '' : 'none';
                }
                if (sel) {
                    sel.disabled = !show;
                    sel.required = !!show;
                    if (!show) clearInput(sel);
                }
            }

            function setSectionState(toggle) {
                const id = toggle.id;
                const on = toggle.checked;
                const body = document.querySelector(`.setting-body[data-for="${id}"]`);
                if (!body) return;
                body.classList.toggle('disabled', !on);
                body.querySelectorAll('input,select,textarea').forEach(f => {
                    // required ديناميكي: رجّع required اللي كان موجود
                    if (f.dataset.wasrequired === '1') f.required = on;
                    f.disabled = !on;
                    if (!on) clearInput(f);
                });
                if (id === 'toggle_refund') {
                    refreshRefundUI(on);
                    const mSel = document.getElementById('refund_method');
                    mSel?.addEventListener('change', () => refreshRefundUI(on));
                }
            }
            // علِّم required الأصلي
            document.querySelectorAll('.setting-body [required]').forEach(f => f.dataset.wasrequired = '1');
            // فعّل الكل أولياً
            document.querySelectorAll('.setting-toggle').forEach(t => {
                setSectionState(t);
                t.addEventListener('change', () => setSectionState(t));
            });

            // ========== فروع مُقدِّمة/بائعة (Repeater) ==========
            const providedWrapper = document.getElementById('providedWrapper');
            const addProvidedBtn = document.getElementById('addProvided');
            const soldWrapper = document.getElementById('soldWrapper');
            const addSoldBtn = document.getElementById('addSold');

            function branchSelectHtml(nameAttr) {
                // options عبر Blade (نطبعها كسلسلة)
                return `
      <select name="${nameAttr}" class="form-select">
        <option value="">— اختر فرع —</option>
        @foreach ($branches as $b)
          <option value="{{ $b->id }}">{{ $b->getTranslation('name', app()->getLocale()) }}</option>
        @endforeach
      </select>`;
            }

            addProvidedBtn?.addEventListener('click', () => {
                const row = document.createElement('div');
                row.className = 'row g-2 align-items-end mb-2 provided-row';
                row.innerHTML = `
      <div class="col-md-10">
        <label class="form-label">اختر فرع</label>
        ${branchSelectHtml('provided_branches[]')}
      </div>
      <div class="col-md-2 d-grid">
        <button type="button" class="btn btn-danger remove-provided"><i class="fas fa-trash"></i></button>
      </div>`;
                providedWrapper.appendChild(row);
            });
            providedWrapper?.addEventListener('click', e => {
                if (e.target.closest('.remove-provided')) {
                    const rows = providedWrapper.querySelectorAll('.provided-row');
                    if (rows.length > 1) e.target.closest('.provided-row').remove();
                }
            });

            addSoldBtn?.addEventListener('click', () => {
                const row = document.createElement('div');
                row.className = 'row g-2 align-items-end mb-2 sold-row';
                row.innerHTML = `
      <div class="col-md-10">
        <label class="form-label">اختر فرع</label>
        ${branchSelectHtml('sold_branches[]')}
      </div>
      <div class="col-md-2 d-grid">
        <button type="button" class="btn btn-danger remove-sold"><i class="fas fa-trash"></i></button>
      </div>`;
                soldWrapper.appendChild(row);
            });
            soldWrapper?.addEventListener('click', e => {
                if (e.target.closest('.remove-sold')) {
                    const rows = soldWrapper.querySelectorAll('.sold-row');
                    if (rows.length > 1) e.target.closest('.sold-row').remove();
                }
            });
        });
    </script>

    <script>
        $(function() {
            // ===== Helpers =====
            function updateCount($grid, selector, $badge) {
                const c = $grid.find(selector + ':checked').length;
                $badge.text(c + ' محدد');
            }

            function attachLiveFilter($search, $grid) {
                $search.on('input', function() {
                    const term = $(this).val().toString().trim().toLowerCase();
                    $grid.find('.branch-col').each(function() {
                        const name = ($(this).data('name') || '').toString();
                        const match = !term || name.indexOf(term) !== -1;
                        this.hidden = !match;
                    });
                });
            }

            function selectVisible($grid, selector) {
                $grid.find('.branch-col:not([hidden]) ' + selector + ':not(:checked)').prop('checked', true)
                    .trigger('change');
            }

            function clearVisible($grid, selector) {
                $grid.find('.branch-col:not([hidden]) ' + selector + ':checked').prop('checked', false).trigger(
                    'change');
            }

            // ===== Provided =====
            const $provGrid = $('#providedGrid');
            const $provBadge = $('#providedCount');
            const $provSearch = $('#providedSearch');

            attachLiveFilter($provSearch, $provGrid);
            updateCount($provGrid, '.provided-item', $provBadge);

            $provGrid.on('change', '.provided-item', function() {
                // تفعيل مظهر البطاقة
                const $lbl = $(this).closest('.check-card');
                $lbl.toggleClass('active', this.checked);
                updateCount($provGrid, '.provided-item', $provBadge);
            });

            $('#providedSelectVisible').on('click', function() {
                selectVisible($provGrid, '.provided-item');
                updateCount($provGrid, '.provided-item', $provBadge);
            });
            $('#providedClearVisible').on('click', function() {
                clearVisible($provGrid, '.provided-item');
                updateCount($provGrid, '.provided-item', $provBadge);
            });

            // إبراز المختار أول تحميل
            $provGrid.find('.provided-item').each(function() {
                $(this).closest('.check-card').toggleClass('active', this.checked);
            });

            // ===== Sold =====
            const $soldGrid = $('#soldGrid');
            const $soldBadge = $('#soldCount');
            const $soldSearch = $('#soldSearch');

            attachLiveFilter($soldSearch, $soldGrid);
            updateCount($soldGrid, '.sold-item', $soldBadge);

            $soldGrid.on('change', '.sold-item', function() {
                const $lbl = $(this).closest('.check-card');
                $lbl.toggleClass('active', this.checked);
                updateCount($soldGrid, '.sold-item', $soldBadge);
            });

            $('#soldSelectVisible').on('click', function() {
                selectVisible($soldGrid, '.sold-item');
                updateCount($soldGrid, '.sold-item', $soldBadge);
            });
            $('#soldClearVisible').on('click', function() {
                clearVisible($soldGrid, '.sold-item');
                updateCount($soldGrid, '.sold-item', $soldBadge);
            });

            $soldGrid.find('.sold-item').each(function() {
                $(this).closest('.check-card').toggleClass('active', this.checked);
            });
        });
    </script>

@endsection
