@extends('layouts.master')

@section('title', __('إعدادات الشركة'))

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <style>
        /* ===== Layout ===== */
        /* .page-header {
                        margin-bottom: 24px;
                    } */

        .page-header h4 {
            font-weight: 700;
        }

        .page-header small {
            opacity: .7;
        }

        .form-section {
            background: linear-gradient(180deg, #0f1e2b, #0c1823);
            border: 1px solid rgba(255, 255, 255, .06);
            box-shadow: 0 10px 25px rgba(0, 0, 0, .25);
            padding: 18px;
            border-radius: 14px;
            margin-bottom: 20px;
        }

        .section-title {
            font-weight: 700;
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            gap: .5rem;
        }

        .form-label {
            font-weight: 600;
        }

        .form-control,
        .form-select {
            background: rgba(255, 255, 255, .03);
            border-color: rgba(255, 255, 255, .08);
            color: #fff;
        }

        .form-control:focus,
        .form-select:focus {
            border-color: #0ea5b6;
            box-shadow: 0 0 0 .15rem rgba(14, 165, 182, .2);
        }

        /* ===== Logo Upload ===== */
        .logo-uploader {
            border: 1px dashed rgba(255, 255, 255, .2);
            border-radius: 14px;
            padding: 14px;
            background: rgba(255, 255, 255, .02);
            cursor: pointer;
        }

        .logo-uploader.dragover {
            border-color: #22d3ee;
            background: rgba(34, 211, 238, .08);
        }

        .logo-preview {
            aspect-ratio: 3 / 1;
            border-radius: 10px;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .logo-preview img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            padding: 10px;
        }

        .logo-placeholder {
            text-align: center;
            opacity: .7;
        }

        /* ===== Phones ===== */
        .phone-row {
            background: rgba(255, 255, 255, .02);
            border: 1px dashed rgba(255, 255, 255, .1);
            padding: 12px;
            border-radius: 10px;
        }

        /* ===== Progress ===== */
        .progress {
            height: 10px;
            border-radius: 10px;
            overflow: hidden;
        }

        /* ===== Buttons ===== */
        .btn-info {
            background: linear-gradient(135deg, #0ea5b6, #22d3ee);
            border: none;
        }
    </style>
@endsection

@section('content')
    <div class="container-fluid">

        <div class="page-header">
            <h4><i class="fas fa-building text-info me-2"></i> إعدادات الشركة</h4>
            <small>إدارة الهوية البصرية وبيانات الشركة الأساسية</small>
        </div>

        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $err)
                        <li>{{ $err }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form id="companyForm" action="{{ route('settings.company.update') }}" method="POST" enctype="multipart/form-data">
            @csrf

            {{-- ===== Visual Identity ===== --}}
            <div class="form-section">
                <div class="section-title text-info">
                    <i class="fas fa-palette"></i> الهوية البصرية
                </div>

                <label class="form-label">الشعار</label>

                <div class="logo-uploader" id="logoDropZone">
                    <div class="logo-preview" id="logoPreview">
                        @if ($setting?->logo_path)
                            <img src="{{ asset($setting->logo_path) }}">
                        @else
                            <div class="logo-placeholder">
                                <i class="fas fa-image fa-2x mb-2"></i>
                                <div>اسحب الشعار هنا أو اضغط للاختيار</div>
                                <small>PNG / JPG / WEBP حتى 2MB</small>
                            </div>
                        @endif
                    </div>

                    <div class="d-flex gap-2 mt-2">
                        <label class="btn btn-outline-info btn-sm mb-0">
                            <i class="fas fa-upload me-1"></i> اختيار ملف
                            <input type="file" id="logoInput" class="d-none" name="logo" accept="image/*">
                        </label>
                        <button type="button" class="btn btn-outline-danger btn-sm" id="logoClear">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>

                <div class="progress mt-3 d-none" id="uploadProgress">
                    <div class="progress-bar progress-bar-striped progress-bar-animated bg-info" style="width:0%">0%</div>
                </div>
            </div>

            {{-- ===== Company Info ===== --}}
            <div class="form-section">
                <div class="section-title text-warning">
                    <i class="fas fa-id-card"></i> البيانات الأساسية
                </div>

                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">الاسم (ar)</label>
                        <input type="text" class="form-control" name="name[ar]"
                            value="{{ old('name.ar', $setting?->getTranslation('name', 'ar')) }}" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">الاسم (en)</label>
                        <input type="text" class="form-control" name="name[en]"
                            value="{{ old('name.en', $setting?->getTranslation('name', 'en')) }}" required>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" class="form-control" name="email"
                            value="{{ old('email', $setting->email ?? '') }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label"> الرقم الضريبى</label>
                        <input type="text" class="form-control" name="tax_number"
                            value="{{ old('tax_number', $setting->tax_number ?? '') }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">الدولة</label>
                        <select class="form-select" name="country_id" required>
                            <option value="">— اختر الدولة —</option>
                            @foreach ($countries as $country)
                                <option value="{{ $country->id }}" @selected(old('country_id', $setting->country_id ?? null) == $country->id)>
                                    {{ $country->getTranslation('name', app()->getLocale()) }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            {{-- ===== Phones ===== --}}
            <div class="form-section">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <div class="section-title text-success mb-0">
                        <i class="fas fa-phone"></i> أرقام الهواتف
                    </div>
                    <button type="button" class="btn btn-info btn-sm" id="addPhone">
                        <i class="fas fa-plus"></i>
                    </button>
                </div>

                <div id="phonesWrapper">
                    @php $phones = old('phones', $setting->phones ?? []); @endphp

                    @forelse($phones as $i => $p)
                        <div class="row g-2 phone-row mb-2 align-items-end">
                            <div class="col-md-3">
                                <input type="text" class="form-control" name="phones[{{ $i }}][label][ar]"
                                    value="{{ $p['label']['ar'] ?? '' }}" placeholder="مسمّى (ar)" required>
                            </div>
                            <div class="col-md-3">
                                <input type="text" class="form-control" name="phones[{{ $i }}][label][en]"
                                    value="{{ $p['label']['en'] ?? '' }}" placeholder="Label (en)" required>
                            </div>
                            <div class="col-md-4">
                                <input type="text" class="form-control" name="phones[{{ $i }}][number]"
                                    value="{{ $p['number'] ?? '' }}" placeholder="رقم الهاتف" required>
                            </div>
                            <div class="col-md-2 d-grid">
                                <button type="button" class="btn btn-danger remove-phone">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    @empty
                    @endforelse
                </div>
            </div>

            <div class="text-end">
                <button class="btn btn-info px-4 py-2">
                    <i class="fas fa-save me-2"></i> حفظ الإعدادات
                </button>
            </div>

        </form>
    </div>
@endsection

@section('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {

            const form = document.getElementById('companyForm');
            const input = document.getElementById('logoInput');
            const preview = document.getElementById('logoPreview');
            const dropZone = document.getElementById('logoDropZone');
            const clearBtn = document.getElementById('logoClear');
            const progress = document.getElementById('uploadProgress');
            const bar = progress.querySelector('.progress-bar');

            function showImage(src) {
                preview.innerHTML = `<img src="${src}">`;
            }

            input.addEventListener('change', e => {
                if (e.target.files[0]) {
                    showImage(URL.createObjectURL(e.target.files[0]));
                }
            });

            clearBtn.addEventListener('click', e => {
                e.stopPropagation();
                input.value = '';
                preview.innerHTML = '';
            });

            dropZone.addEventListener('click', e => {
                if (e.target === dropZone || e.target === preview) {
                    input.click();
                }
            });

            form.addEventListener('submit', function(e) {
                e.preventDefault();

                const xhr = new XMLHttpRequest();
                const data = new FormData(form);

                progress.classList.remove('d-none');
                bar.style.width = '0%';
                bar.innerText = '0%';

                xhr.upload.onprogress = e => {
                    if (e.lengthComputable) {
                        let p = Math.round((e.loaded / e.total) * 100);
                        bar.style.width = p + '%';
                        bar.innerText = p + '%';
                    }
                };

                xhr.onload = () => {
                    bar.classList.remove('bg-info');
                    bar.classList.add('bg-success');
                    bar.innerText = 'تم الحفظ ✔';
                    setTimeout(() => location.reload(), 800);
                };

                xhr.open('POST', form.action);
                xhr.send(data);
            });

        });
    </script>
@endsection
