@php
    use App\Models\CompanySetting;

    $company = CompanySetting::first();

    $companyName = $company ? $company->getTranslation('name', app()->getLocale()) : '—';

    $taxNumber = $company->tax_number ?? '—';
@endphp



<div class="invoice"
    style="padding:40px 50px;border:1px solid #e3e3e3;border-radius:8px;max-width:900px;margin:auto;color:#222;">

    {{-- HEADER --}}
    <div class="d-flex justify-content-between align-items-start"
        style="border-bottom:2px solid #dee2e6;padding-bottom:15px;margin-bottom:20px;">
        <div>
            <h3 style="margin:0;font-weight:700;">فاتورة ضريبية مبسطة<br>
                <small style="color:#777;">Simplified Tax Invoice</small>
            </h3>
        </div>
        <div class="text-end">
            <div class="qrcode_box_{{ $sub->id }}"></div>
        </div>
    </div>


    {{-- BASIC --}}
    <div class="row mb-4">
        <div class="col-md-6">
            <p><strong>رقم الفاتورة:</strong> {{ $sub->invoice_no }}</p>

            <p><strong>رقم الاعتماد / Verification Code:</strong>
                @if ($sub->status === 'approved')
                    <span class="text-success">{{ $sub->verification_code ?? '—' }}</span>
                @else
                    <span class="text-muted">— غير معتمد —</span>
                @endif
            </p>

            <p><strong>Date / التاريخ:</strong> {{ $sub->created_at->format('Y-m-d') }}</p>

            <p>
                <strong>الرقم الضريبي:</strong>
                {{ $taxNumber }}
            </p>

        </div>

        <div class="col-md-6 text-md-end">
            <p><strong>العضو:</strong> {{ $sub->member->name ?? '—' }}</p>
            <p><strong>الفرع:</strong> {{ $sub->branch->name ?? '—' }}</p>

            <p><strong>مقدم الخدمة:</strong> {{ $sub->serviceUser->name ?? '—' }}</p>
            <p><strong>مسؤول المبيعات:</strong> {{ $sub->providerUser->name ?? '—' }}</p>

            <p><strong>الحالة:</strong>
                @if ($sub->status === 'approved')
                    <span class="text-success">معتمد</span>
                @elseif($sub->status === 'rejected')
                    <span class="text-danger">مرفوض</span>
                @else
                    <span class="text-warning">تحت المراجعة</span>
                @endif
            </p>

        </div>
    </div>


    {{-- DATES --}}
    <div class="row mt-4 mb-3 text-center small bg-light rounded-3 py-3">
        <div class="col-md-6">
            <b>📅 بداية الاشتراك:</b> {{ $sub->start_date->format('Y-m-d') }}
        </div>

        <div class="col-md-6">
            <b>⏳ نهاية الاشتراك:</b> {{ $sub->end_date->format('Y-m-d') }}
        </div>
    </div>


    {{-- ITEMS (معادلات جديدة 100%) --}}
    @php
        // السعر الأساسي = price
        $base_price = $sub->price;

        // الخصم الإضافي = discount
        $extra_discount = $sub->discount;

        // الضريبة المحفوظة في الداتابيز
        $tax = $sub->tax;

        // الإجمالي بعد الضريبة
        $total = $sub->total;

        // الصافي قبل الضريبة
        $net_amount = $total - $tax;
    @endphp

    <table class="table table-bordered text-center align-middle">
        <thead>
            <tr>
                <th>الوصف</th>

                <th>السعر الأساسي</th>
                <th>الخصم الإضافي</th>
                <th>الصافي قبل الضريبة</th>
                <th>الضريبة (15%)</th>
                <th>الإجمالي</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>{{ $sub->item_name }}</td>

                <td>{{ number_format($base_price, 2) }}</td>
                <td>{{ number_format($extra_discount, 2) }}</td>
                <td class="text-info fw-bold">{{ number_format($net_amount, 2) ?? '122' }}</td>
                <td>{{ number_format($tax, 2) }}</td>
                <td class="fw-bold text-success">{{ number_format($total, 2) }}</td>
            </tr>
        </tbody>


    </table>



    {{-- PAYMENT METHODS --}}
    @php
        $payments = is_array($sub->payment_methods) ? $sub->payment_methods : json_decode($sub->payment_methods, true);
    @endphp

    @if (!empty($payments))
        <h6 class="fw-bold mt-4 mb-2">💳 تفاصيل الدفع</h6>
        <table class="table table-bordered text-center table-sm align-middle">
            <thead>
                <tr>
                    <th>طريقة الدفع</th>
                    <th>المبلغ</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($payments as $p)
                    @php
                        $method = \App\Models\PaymentMethod::find($p['method_id'] ?? null);
                    @endphp
                    <tr>
                        <td>{{ $method->name_ar ?? '—' }}</td>
                        <td>{{ number_format($p['amount'] ?? 0, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif


    {{-- TOTAL --}}
    <div style="background:#f8f9fa;border:1px solid #e0e0e0;border-radius:8px;padding:15px;margin-top:20px;">
        <div class="d-flex justify-content-between align-items-center">
            <strong>الإجمالي شامل الضريبة</strong>
            <h5 style="margin:0;font-weight:700;color:#198754;">
                {{ number_format($sub->total, 2) }}
            </h5>
        </div>
    </div>


    {{-- FOOTER --}}
    <div class="text-center mt-3" style="font-size:13px;color:#666;">
        شكراً لاختياركم خدمتنا ❤️<br>Thank you for choosing our service
    </div>

</div>


<script>
    document.addEventListener("DOMContentLoaded", function() {

        function toTLV(tag, value) {
            const textEncoder = new TextEncoder();
            const valueBytes = textEncoder.encode(value);
            return new Uint8Array([tag, valueBytes.length, ...valueBytes]);
        }

        const sellerName = @json($companyName);
        const vatNumber = @json($taxNumber);

        const date = "{{ $sub->created_at->format('Y-m-d\TH:i:s') }}";
        const total = "{{ number_format($sub->total, 2, '.', '') }}";
        const vat = "{{ number_format($sub->tax, 2, '.', '') }}";

        const tlv = [
            toTLV(1, sellerName),
            toTLV(2, vatNumber),
            toTLV(3, date),
            toTLV(4, total),
            toTLV(5, vat)
        ];

        const merged = new Uint8Array(tlv.flatMap(v => Array.from(v)));
        const base64 = btoa(String.fromCharCode(...merged));

        const qrUrl =
            `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(base64)}&size=130x130`;

        document.querySelector(".qrcode_box_{{ $sub->id }}").innerHTML =
            `<img src="${qrUrl}" width="130" height="130"
                  style="border:1px solid #ddd;border-radius:8px;">`;
    });
</script>
