@extends('layouts.master')

@section('title', 'طباعة مجموعة فواتير')

@section('css')
    <style>
        body {
            background: #fff !important;
        }

        /* فاصل بين كل فاتورة */
        .page-break {
            page-break-after: always;
        }

        /* تأكيد عدم قص الأطراف */
        @media print {
            @page {
                margin: 10mm;
            }
        }
    </style>
@endsection

@section('content')
    <div class="container my-4">

        @foreach ($subs as $sub)
            {{-- 🔹 إدراج نفس تصميم الفاتورة الأصلية --}}
            @include('admin.subscriptions.invoice-layout', ['sub' => $sub])

            {{-- 🔹 فاصل صفحة بين كل فاتورة --}}
            @if (!$loop->last)
                <div class="page-break"></div>
            @endif
        @endforeach

    </div>
@endsection

@section('js')
    <script>
        // تشغيل الطباعة تلقائياً بعد تحميل الصفحة
        window.onload = function() {
            window.print();
        };
    </script>
@endsection
