@extends('layouts.master')
@section('title', 'عرض اشتراك')

@section('content')
    <div class="container-fluid">

        {{-- HEADER --}}
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3 class="fw-bold text-light">
                <i class="fas fa-id-card me-2 text-info"></i>
                عرض اشتراك رقم {{ $sub->invoice_no ?? '—' }}
            </h3>

            <div>
                <a href="{{ route('subscriptions.invoice', $sub->id) }}" target="_blank" class="btn btn-warning">
                    <i class="fas fa-print"></i> طباعة
                </a>
            </div>
        </div>

        {{-- BASIC INFO --}}
        <div class="card-flat mb-3">
            <h5 class="mb-3 section-title">تفاصيل الاشتراك</h5>

            <div class="row g-3">

                <div class="col-md-4">
                    الفرع:
                    <strong>{{ $sub->branch->name ?? '—' }}</strong>
                </div>

                <div class="col-md-4">
                    العضو:
                    <strong>{{ $sub->member->name ?? '—' }}</strong>
                </div>

                <div class="col-md-4">
                    مسجّل الاشتراك:
                    <strong>{{ $sub->creator->name ?? '—' }}</strong>
                </div>

                <div class="col-md-4">
                    نوع الاشتراك:
                    <strong>
                        {{ $sub->subscription_type === 'service' ? 'خدمة' : 'عرض' }}
                    </strong>
                </div>

                <div class="col-md-4">
                    رقم الاعتماد:
                    <strong>{{ $sub->verification_code ?? '—' }}</strong>
                </div>

                <div class="col-md-4">
                    الحالة:
                    @php
                        $statusMap = [
                            'approved' => ['success', 'معتمد'],
                            'under_review' => ['warning', 'تحت المراجعة'],
                            'rejected' => ['danger', 'مرفوض'],
                            'new' => ['secondary', 'جديد'],
                        ];
                        [$cls, $txt] = $statusMap[$sub->status] ?? ['secondary', '—'];
                    @endphp
                    <span class="badge bg-{{ $cls }}">{{ $txt }}</span>
                </div>

            </div>
        </div>

        {{-- ITEM DETAILS --}}
        <div class="card-flat mb-3">
            <h5 class="section-title mb-2">تفاصيل العنصر</h5>

            <table class="table table-dark table-bordered text-center align-middle">
                <thead>
                    <tr>
                        <th>العنصر</th>
                        <th>السعر</th>
                        <th>الخصم</th>
                        <th>الصافي</th>
                        <th>الضريبة</th>
                        <th>الإجمالي</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $net = ($sub->price ?? 0) - ($sub->discount ?? 0);
                    @endphp
                    <tr>
                        <td>{{ $sub->item_name ?? '—' }}</td>
                        <td>{{ number_format($sub->price ?? 0, 2) }}</td>
                        <td>{{ number_format($sub->discount ?? 0, 2) }}</td>
                        <td class="text-info fw-bold">{{ number_format($net, 2) }}</td>
                        <td>{{ number_format($sub->tax ?? 0, 2) }}</td>
                        <td class="text-success fw-bold">{{ number_format($sub->total ?? 0, 2) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>

        {{-- PAYMENT METHODS --}}
        @php
            $payments = is_array($sub->payment_methods)
                ? $sub->payment_methods
                : json_decode($sub->payment_methods, true);

            $payments = collect($payments);

            $paymentMethods = \App\Models\PaymentMethod::where('active', 1)->get()->keyBy('id');
        @endphp

        @if ($payments->isNotEmpty())
            <div class="card-flat mb-3">
                <h5 class="section-title mb-2">تفاصيل الدفع</h5>

                <table class="table table-dark table-bordered text-center align-middle">
                    <thead>
                        <tr>
                            <th>طريقة الدفع</th>
                            <th>المبلغ</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($payments as $p)
                            @php
                                $methodId = $p['method_id'] ?? null;
                                $method = $methodId ? $paymentMethods[$methodId] ?? null : null;
                            @endphp
                            <tr>
                                <td>
                                    {{ $method ? (app()->getLocale() === 'ar' ? $method->name_ar : $method->name_en) : '—' }}
                                </td>
                                <td>{{ number_format($p['amount'] ?? 0, 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif

        {{-- PERIOD --}}
        <div class="row g-3">
            <div class="col-md-6">
                <div class="card-flat">
                    تاريخ البداية:
                    <strong>{{ optional($sub->start_date)->format('Y-m-d') ?? '—' }}</strong>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card-flat">
                    تاريخ الانتهاء:
                    <strong>{{ optional($sub->end_date)->format('Y-m-d') ?? '—' }}</strong>
                </div>
            </div>
        </div>

    </div>
@endsection
