@extends('frontEnd.layouts.Fmaster')

@section('FrontCss')
    <style>
        .offer-card {
            background: #1f1f1f;
            border: 1px solid #333;
            border-radius: 15px;
            padding: 22px;
            text-align: center;
            color: #fff;
            transition: .3s ease;
        }

        .offer-card:hover {
            transform: translateY(-6px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.4);
        }

        .offer-logo {
            width: 80px;
            margin: 0 auto 15px;
            display: block;
        }

        .offer-price {
            font-size: 30px;
            font-weight: bold;
            color: #d8c1a0;
            margin: 12px 0;
        }

        .details-toggle {
            cursor: pointer;
            background: rgba(255, 255, 255, 0.08);
            padding: 12px;
            border-radius: 10px;
            color: #d8c1a0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-weight: bold;
            transition: .3s ease;
            margin-top: 15px;
        }

        .details-toggle:hover {
            background: rgba(255, 255, 255, 0.16);
        }

        .details-toggle i {
            transition: .3s ease;
        }

        .details-toggle.active i {
            transform: rotate(180deg);
        }

        .services-list {
            display: none;
            margin-top: 15px;
            animation: fadeDown .4s ease forwards;
        }

        .service-item {
            display: flex;
            gap: 15px;
            padding: 12px;
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.05);
            margin-bottom: 10px;
            transition: .25s ease;
        }

        .service-item:hover {
            background: rgba(255, 255, 255, 0.12);
            transform: translateX(-4px);
        }

        .service-icon {
            width: 42px;
            height: 42px;
            display: flex;
            justify-content: center;
            align-items: center;
            border-radius: 10px;
            color: #000;
            font-size: 20px;
        }

        .service-name {
            font-weight: bold;
            font-size: 15px;
        }

        .service-meta {
            margin-top: 4px;
            font-size: 13px;
            color: #ccc;
        }

        .custom-badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            background: linear-gradient(135deg, #ad690a, #c5ad85);
            color: #000;
            font-weight: bold;
            padding: 6px 12px;
            border-radius: 12px;
            font-size: 14px;
            margin-bottom: 6px;
        }

        @keyframes fadeDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
@endsection


@section('FrontContent')
    <section class="pricing-section py-5">
        <div class="container text-center">

            <h2 class="fw-bold mb-1">{{ __('offers.title') }}</h2>
            <p class="mb-5">{{ __('offers.subtitle') }}</p>

            <div class="row g-4 justify-content-center">

                @foreach ($offers as $offer)
                    @php
                        $nameData = is_string($offer->name) ? json_decode($offer->name, true) : $offer->name;
                        $offerName = $nameData[app()->getLocale()] ?? ($nameData['ar'] ?? 'Offer');

                        $total = $offer->items->sum('final_price');
                        $servicesCount = $offer->items->count();
                        $collapseId = 'services_' . $offer->id;
                    @endphp

                    <div class="col-md-4">
                        <div class="offer-card">

                            <img src="{{ asset('front_assets/imge/logo 1.png') }}" class="offer-logo">

                            <h4>{{ $offerName }}</h4>

                            <div class="offer-price">${{ $total }}</div>

                            <p class="offer-desc">
                                {{ __('offers.includes_services', ['count' => $servicesCount]) }}
                                {{ __('offers.extra_days', ['days' => $offer->extra_days ?? 0]) }}
                            </p>

                            <div class="details-toggle" data-target="{{ $collapseId }}">
                                <span>{{ __('offers.details') }}</span>
                                <i class="bi bi-chevron-down"></i>
                            </div>

                            <div class="services-list" id="{{ $collapseId }}">
                                @foreach ($offer->items as $item)
                                    <div class="service-item">

                                        <div class="service-icon">
                                            <i class="bi bi-lightning-charge"></i>
                                        </div>

                                        <div class="service-text">
                                            <div class="custom-badge">
                                                <i class="bi bi-check2-circle"></i>
                                                {{ $item->service_name }}
                                            </div>

                                            <div class="service-meta">
                                                <i class="bi bi-cash-coin"></i>
                                                {{ __('offers.service_price') }} {{ $item->final_price }}
                                                <br>
                                                <i class="bi bi-clock"></i>
                                                {{ __('offers.service_duration') }}
                                                {{ $item->final_duration_value }}
                                                {{ $item->final_duration_unit }}
                                            </div>

                                        </div>

                                    </div>
                                @endforeach
                            </div>

                        </div>
                    </div>
                @endforeach

            </div>

        </div>
    </section>
@endsection


@section('FrontJs')
    <script>
        document.querySelectorAll('.details-toggle').forEach(btn => {
            btn.addEventListener('click', () => {
                let target = document.getElementById(btn.dataset.target);

                btn.classList.toggle('active');

                target.style.display = target.style.display === "block" ? "none" : "block";
            });
        });
    </script>
@endsection
