@extends('frontEnd.layouts.Fmaster')

@section('FrontCss')
    <style>
        .sub-card {
            background: #1f1f1f;
            border: 1px solid #333;
            border-radius: 15px;
            padding: 22px;
            text-align: center;
            color: #f5f5f5;
            transition: .3s
        }

        .sub-card:hover {
            transform: translateY(-6px);
            box-shadow: 0 0 14px rgba(255, 255, 255, .08)
        }

        .sub-logo {
            width: 85px;
            margin-bottom: 15px
        }

        .subscriber-name {
            color: #d8c1a0;
            font-size: 20px;
            font-weight: 700
        }

        .sub-title {
            font-size: 17px;
            margin-top: 8px
        }

        .sub-price {
            font-size: 26px;
            color: #d8c1a0;
            font-weight: bold;
            margin-top: 10px
        }

        .details-toggle {
            background: rgba(255, 255, 255, .06);
            padding: 10px;
            border-radius: 8px;
            cursor: pointer;
            margin-top: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center
        }

        .details-content {
            display: none;
            margin-top: 15px;
            text-align: right
        }

        .service-block {
            background: #252525;
            border: 1px solid #3a3a3a;
            border-radius: 12px;
            margin-bottom: 12px
        }

        .service-header {
            padding: 12px 16px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            cursor: pointer;
            background: #2d2d2d
        }

        .service-header.active .toggle-icon {
            transform: rotate(180deg)
        }

        .service-body {
            padding: 15px 18px;
            display: none
        }

        .srv-row {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 8px;
            color: #ddd;
            font-size: 14px
        }

        .srv-row i {
            color: #d8c1a0
        }

        .srv-desc {
            background: #1f1f1f;
            border-radius: 10px;
            padding: 10px 15px;
            margin-top: 10px;
            font-size: 13px;
            color: #ccc
        }
    </style>
@endsection


@section('FrontContent')
    <section class="pricing-section py-5 d-none">
        <div class="container text-center">

            <h2 class="fw-bold mb-2">{{ __('subscriptions.title') }}</h2>
            <p class="mb-5">{{ __('subscriptions.subtitle') }}</p>

            <div class="row g-4 justify-content-center">

                @foreach ($subscriptions as $sub)
                    <div class="col-md-4">
                        <div class="sub-card">

                            <img src="{{ asset('front_assets/imge/logo 1.png') }}" class="sub-logo" width="30px">

                            <div class="subscriber-name">{{ $sub->subscriber_name }}</div>

                            <div class="sub-title">
                                {{ __('subscriptions.type') }}:
                                {{ $sub->subscription_type === 'service' ? __('subscriptions.service_type') : __('subscriptions.offer_type') }}
                            </div>

                            <div class="sub-price">${{ $sub->total_price }}</div>

                            <div class="details-toggle" data-id="details_{{ $sub->id }}">
                                <span>{{ __('subscriptions.show_details') }}</span>
                                <i class="bi bi-chevron-down"></i>
                            </div>

                            <div class="details-content" id="details_{{ $sub->id }}">

                                @forelse ($sub->items_data as $item)
                                    <div class="service-block">
                                        <div class="service-header"
                                            data-expand="srv_{{ $sub->id }}_{{ $loop->index }}">
                                            <div class="left">
                                                <i class="bi bi-lightning-charge-fill icon-main"></i>
                                                <span class="title">{{ $item['name'] }}</span>
                                            </div>
                                            <i class="bi bi-chevron-down toggle-icon"></i>
                                        </div>

                                        <div class="service-body" id="srv_{{ $sub->id }}_{{ $loop->index }}">
                                            <div class="srv-row">
                                                <i class="bi bi-cash-coin"></i>
                                                <span>{{ __('subscriptions.price') }}:</span>
                                                <strong>{{ $item['price'] }}</strong>
                                            </div>

                                            <div class="srv-row">
                                                <i class="bi bi-hourglass-split"></i>
                                                <span>{{ __('subscriptions.duration') }}:</span>
                                                <strong>{{ $item['duration_value'] }}
                                                    {{ $item['duration_unit'] }}</strong>
                                            </div>

                                            <div class="srv-desc">
                                                {{ __('subscriptions.default_desc') }}
                                            </div>
                                        </div>
                                    </div>

                                @empty
                                    <div class="text-muted">
                                        {{ __('subscriptions.no_services') }}
                                    </div>
                                @endforelse

                            </div>

                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </section>



    <section class="pricing-section py-5">
        <div class="container text-center">

            <h2 class="fw-bold mb-2">سياسة الأسعار</h2>
            <p class="mb-5">Shpooov Gym</p>

            <div class="row g-4 justify-content-center">

                {{-- ========== الاشتراك السنوي ========== --}}
                <div class="col-md-4">
                    <div class="sub-card">

                        <img src="{{ asset('front_assets/imge/logo 1.png') }}" class="sub-logo">

                        <div class="subscriber-name">اشتراك سنوي</div>

                        <div class="sub-title">
                            المدة: <strong>12 شهر</strong>
                        </div>

                        <div class="sub-price">5,999 ريال</div>
                        <small class="">غير شامل ضريبة القيمة المضافة</small>

                        <div class="details-toggle" data-id="details_year">
                            <span>عرض التفاصيل</span>
                            <i class="bi bi-chevron-down"></i>
                        </div>

                        <div class="details-content" id="details_year">

                            <div class="service-block">
                                <div class="service-header active">
                                    <div class="left">
                                        <i class="bi bi-lightning-charge-fill icon-main"></i>
                                        <span class="title">مزايا الاشتراك</span>
                                    </div>
                                    <i class="bi bi-chevron-down toggle-icon"></i>
                                </div>

                                <div class="service-body" style="display:block">
                                    <div class="srv-row">
                                        <i class="bi bi-check-circle-fill"></i>
                                        <span>مدة الاشتراك:</span>
                                        <strong>12 شهر من تاريخ التفعيل</strong>
                                    </div>

                                    <div class="srv-row">
                                        <i class="bi bi-cash-coin"></i>
                                        <span>السعر:</span>
                                        <strong>5,999 ريال</strong>
                                    </div>

                                    <div class="srv-desc">
                                        اشتراك كامل يشمل جميع خدمات النادي طوال فترة الاشتراك.
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                {{-- ========== الاشتراك نصف السنوي ========== --}}
                <div class="col-md-4">
                    <div class="sub-card">

                        <img src="{{ asset('front_assets/imge/logo 1.png') }}" class="sub-logo">

                        <div class="subscriber-name">اشتراك نصف سنوي</div>

                        <div class="sub-title">
                            المدة: <strong>6 أشهر</strong>
                        </div>

                        <div class="sub-price">3,999 ريال</div>
                        <small class="">غير شامل ضريبة القيمة المضافة</small>

                        <div class="details-toggle" data-id="details_half">
                            <span>عرض التفاصيل</span>
                            <i class="bi bi-chevron-down"></i>
                        </div>

                        <div class="details-content" id="details_half">

                            <div class="service-block">
                                <div class="service-header active">
                                    <div class="left">
                                        <i class="bi bi-lightning-charge-fill icon-main"></i>
                                        <span class="title">مزايا الاشتراك</span>
                                    </div>
                                    <i class="bi bi-chevron-down toggle-icon"></i>
                                </div>

                                <div class="service-body" style="display:block">
                                    <div class="srv-row">
                                        <i class="bi bi-check-circle-fill"></i>
                                        <span>مدة الاشتراك:</span>
                                        <strong>6 أشهر من تاريخ التفعيل</strong>
                                    </div>

                                    <div class="srv-row">
                                        <i class="bi bi-cash-coin"></i>
                                        <span>السعر:</span>
                                        <strong>3,999 ريال</strong>
                                    </div>

                                    <div class="srv-desc">
                                        اشتراك مرن مناسب للتجربة والاستفادة من خدمات النادي.
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
@endsection



@section('FrontJs')
    <script>
        document.querySelectorAll('.details-toggle').forEach(btn => {
            btn.addEventListener('click', function() {
                let id = this.dataset.id;
                let box = document.getElementById(id);

                document.querySelectorAll('.details-content').forEach(c => {
                    if (c.id !== id) c.style.display = 'none';
                });

                box.style.display = box.style.display === 'block' ? 'none' : 'block';
            });
        });

        document.querySelectorAll('.service-header').forEach(head => {
            head.addEventListener('click', function() {
                let id = this.dataset.expand;
                let body = document.getElementById(id);

                document.querySelectorAll('.service-body').forEach(b => {
                    if (b.id !== id) b.style.display = 'none';
                });

                body.style.display = body.style.display === 'block' ? 'none' : 'block';
                this.classList.toggle('active');
            });
        });
    </script>
@endsection
