 <aside class="page-sidebar bg-dark text-white shadow-lg position-fixed h-100" id="sidebar">

     <nav class="sidebar-menu mt-3">
         <ul class="list-unstyled px-2">

             <!-- Dashboard -->
             <li class="mb-2">
                 <a href="{{ route('admin.dashboard') }}"
                     class="d-flex align-items-center gap-3 text-white text-decoration-none py-2 px-3 rounded hover-item">
                     <i class="fa-solid fa-gauge-high fa-lg text-info"></i>
                     <span>{{ __('sidebar.dashboard') }}</span>
                 </a>
             </li>
             <li class="mb-2">
                 <a href="{{ route('settings.company.edit') }}"
                     class="d-flex align-items-center gap-3 text-white text-decoration-none py-2 px-3 rounded hover-item">
                     <i class="fa-solid fa-cog fa-lg text-info"></i>
                     <span>{{ __('dashboard.setting') }}</span>
                 </a>
             </li>

             <li class="mb-2">
                 <a href="{{ route('home') }}" target="_blank"
                     class="d-flex align-items-center gap-3 text-white text-decoration-none py-2 px-3 rounded hover-item">
                     <i class="fa-solid fa-globe fa-lg text-info"></i>
                     <span>{{ __('dashboard.show_webSite') }}</span>
                 </a>
             </li>
             <hr class="border-secondary my-2">

             <!-- Branches -->
             <li class="menu-group">
                 <button
                     class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                     <i class="fa-solid fa-building fa-lg text-success"></i>
                     <span>{{ __('sidebar.branches') }}</span>
                     <i class="fa-solid fa-angle-down me-auto"></i>
                 </button>

                 <ul class="submenu list-unstyled ms-4 mt-1">
                     <li><a href="{{ route('branch-categories.index') }}"
                             class="submenu-item">{{ __('sidebar.branch_categories') }}</a></li>
                     <li><a href="{{ route('branch-types.index') }}"
                             class="submenu-item">{{ __('sidebar.branch_types') }}</a></li>
                     <li><a href="{{ route('branches.index') }}"
                             class="submenu-item">{{ __('sidebar.branches_list') }}</a></li>
                 </ul>
             </li>

             <!-- Services -->
             <li class="menu-group">
                 <button
                     class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                     <i class="fa-solid fa-dumbbell fa-lg text-primary"></i>
                     <span>{{ __('sidebar.services') }}</span>
                     <i class="fa-solid fa-angle-down me-auto"></i>
                 </button>

                 <ul class="submenu list-unstyled ms-4 mt-1">
                     <li><a href="{{ route('service-types.index') }}"
                             class="submenu-item">{{ __('sidebar.service_types') }}</a></li>
                     <li><a href="{{ route('service-categories.index') }}"
                             class="submenu-item">{{ __('sidebar.service_categories') }}</a></li>
                     <li><a href="{{ route('services.index') }}"
                             class="submenu-item">{{ __('sidebar.services_list') }}</a></li>
                 </ul>
             </li>

             <!-- Customers -->
             <li class="menu-group">
                 <button
                     class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                     <i class="fa-solid fa-user-group fa-lg text-info"></i>
                     <span>{{ __('sidebar.customers') }}</span>
                     <i class="fas fa-angle-down me-auto"></i>
                 </button>

                 <ul class="submenu list-unstyled ms-4 mt-1">
                     <li><a href="{{ route('customers.index') }}"
                             class="submenu-item">{{ __('sidebar.customers_list') }}</a></li>
                     <li><a href="{{ route('customers.create') }}"
                             class="submenu-item">{{ __('sidebar.customer_create') }}</a></li>
                 </ul>
             </li>

             <!-- Members -->
             <li class="menu-group">
                 <button
                     class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                     <i class="fas fa-users fa-lg text-success"></i>
                     <span>{{ __('sidebar.members') }}</span>
                     <i class="fas fa-angle-down me-auto"></i>
                 </button>

                 <ul class="submenu list-unstyled ms-4 mt-1">
                     <li><a href="{{ route('members.index') }}"
                             class="submenu-item">{{ __('sidebar.members_list') }}</a></li>
                     <li><a href="{{ route('members.create') }}"
                             class="submenu-item">{{ __('sidebar.member_create') }}</a></li>
                 </ul>
             </li>

             <!-- Offers -->
             <li class="menu-group">
                 <button
                     class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                     <i class="fa-solid fa-tags fa-lg text-danger"></i>
                     <span>{{ __('sidebar.offers') }}</span>
                     <i class="fa-solid fa-angle-down me-auto"></i>
                 </button>

                 <ul class="submenu list-unstyled ms-4 mt-1">
                     <li><a href="{{ route('offers.index') }}"
                             class="submenu-item">{{ __('sidebar.offers_list') }}</a>
                     </li>
                     <li><a href="{{ route('offers.create') }}"
                             class="submenu-item">{{ __('sidebar.offer_create') }}</a></li>
                 </ul>
             </li>

             <!-- Subscription -->
             <li class="menu-group">
                 <button
                     class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                     <i class="fa-solid fa-lg fa-shopping-cart text-danger"></i>
                     <span>{{ __('sidebar.subscriptions') }}</span>
                     <i class="fa-solid fa-angle-down me-auto"></i>
                 </button>

                 <ul class="submenu list-unstyled ms-4 mt-1">
                     <li><a href="{{ route('subscriptions.index') }}"
                             class="submenu-item">{{ __('sidebar.subscriptions_list') }}</a></li>
                     <li><a href="{{ route('subscriptions.create') }}"
                             class="submenu-item">{{ __('sidebar.subscription_create') }}</a></li>
                 </ul>
             </li>

             <!-- Service Invoices -->
             <li class="menu-group">
                 <button
                     class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                     <i class="fa-solid fa-lg fa-file-invoice-dollar text-warning"></i>
                     <span>{{ __('sidebar.service_invoices') }}</span>
                     <i class="fa-solid fa-angle-down me-auto"></i>
                 </button>

                 <ul class="submenu list-unstyled ms-4 mt-1">
                     <li><a href="{{ route('service-invoices.index') }}"
                             class="submenu-item">{{ __('sidebar.service_invoices_list') }}</a></li>
                     <li><a href="{{ route('service-invoices.create') }}"
                             class="submenu-item">{{ __('sidebar.service_invoices_create') }}</a></li>
                 </ul>
             </li>

             <!-- Payment Methods -->
             <li class="menu-group">
                 <button
                     class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                     <i class="fa-solid fa-credit-card fa-lg text-info"></i>
                     <span>{{ __('sidebar.payment_methods') }}</span>
                     <i class="fa-solid fa-angle-down me-auto"></i>
                 </button>

                 <ul class="submenu list-unstyled ms-4 mt-1">
                     <li><a href="{{ route('payment-methods.index') }}"
                             class="submenu-item">{{ __('sidebar.payment_methods_list') }}</a></li>
                 </ul>
             </li>


             <!-- Reports -->
             <li class="menu-group">
                 <button
                     class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                     <i class="fa-solid fa-file fa-lg text-info"></i>
                     <span>{{ __('sidebar.reports') }}</span>
                     <i class="fa-solid fa-angle-down me-auto"></i>
                 </button>

                 <ul class="submenu list-unstyled ms-4 mt-1">
                     <li><a href="{{ route('reports.service-invoices') }}"
                             class="submenu-item">{{ __('dashboard.invoice_report') }}</a></li>

                     <li><a href="{{ route('reports.subscriptions') }}"
                             class="submenu-item">{{ __('dashboard.subscriptions_report') }}</a>
                     </li>
                 </ul>
             </li>





             <!-- Users -->
             <li class="menu-group">
                 <button
                     class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                     <i class="fa-solid fa-user-shield fa-lg text-warning"></i>
                     <span>{{ __('sidebar.users_permissions') }}</span>
                     <i class="fa-solid fa-angle-down me-auto"></i>
                 </button>

                 <ul class="submenu list-unstyled ms-4 mt-1">
                     <li><a href="{{ route('roles.index') }}" class="submenu-item">{{ __('sidebar.roles') }}</a>
                     </li>
                     <li><a href="{{ route('users.index') }}"
                             class="submenu-item">{{ __('sidebar.users_list') }}</a>
                     </li>
                 </ul>
             </li>


         </ul>
     </nav>
 </aside>


 <style>
     /* Sidebar Base */
     .sidebar {
         width: 270px;
         transition: all 0.3s ease;
         overflow-y: auto;
         z-index: 1000;
     }

     .sidebar.collapsed {
         width: 80px;
     }

     .hover-item:hover {
         background: rgba(255, 255, 255, 0.1);
         transition: 0.3s;
     }

     /* Submenu */
     .submenu {
         display: none;
         padding-right: 5px;
         transition: all 0.3s ease;
     }

     .submenu-item {
         display: block;
         color: #bbb;
         padding: 6px 10px;
         text-decoration: none;
         border-radius: 6px;
         font-size: 14px;
     }

     .submenu-item:hover {
         background: rgba(255, 255, 255, 0.1);
         color: #fff;
     }

     .menu-group.open>.submenu {
         display: block;
         animation: fadeIn 0.3s;
     }

     @keyframes fadeIn {
         from {
             opacity: 0;
             transform: translateY(-10px);
         }

         to {
             opacity: 1;
             transform: translateY(0);
         }
     }
 </style>

 <script>
     document.addEventListener('DOMContentLoaded', function() {
         // Toggle submenus
         document.querySelectorAll('.toggle-submenu').forEach(btn => {
             btn.addEventListener('click', function() {
                 const parent = this.closest('.menu-group');
                 parent.classList.toggle('open');
                 this.querySelector('i.fa-angle-down').classList.toggle('fa-rotate-180');
             });
         });

         // Collapse sidebar
         document.getElementById('toggleSidebar').addEventListener('click', () => {
             document.getElementById('sidebar').classList.toggle('collapsed');
         });
     });
 </script>
