{{-- Admin sidebar --}}



@if (auth('web')->check() && request()->routeIs('admin.*'))
    @include('layouts.partials.sidebar_admin')
@endif

{{-- End Admin sidebar --}}

{{-- member sidebar --}}
@if (auth('member')->check() && request()->routeIs('member.*'))
    @include('layouts.partials.sidebar_member')
@endif

{{-- End member sidebar --}}


<style>
    /* Sidebar Base */
    .sidebar {
        width: 270px;
        transition: all 0.3s ease;
        overflow-y: auto;
        z-index: 1000;
    }

    .sidebar.collapsed {
        width: 80px;
    }

    .hover-item:hover {
        background: rgba(255, 255, 255, 0.1);
        transition: 0.3s;
    }

    /* Submenu */
    .submenu {
        display: none;
        padding-right: 5px;
        transition: all 0.3s ease;
    }

    .submenu-item {
        display: block;
        color: #bbb;
        padding: 6px 10px;
        text-decoration: none;
        border-radius: 6px;
        font-size: 14px;
    }

    .submenu-item:hover {
        background: rgba(255, 255, 255, 0.1);
        color: #fff;
    }

    .menu-group.open>.submenu {
        display: block;
        animation: fadeIn 0.3s;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Toggle submenus
        document.querySelectorAll('.toggle-submenu').forEach(btn => {
            btn.addEventListener('click', function() {
                const parent = this.closest('.menu-group');
                parent.classList.toggle('open');
                this.querySelector('i.fa-angle-down').classList.toggle('fa-rotate-180');
            });
        });

        // Collapse sidebar
        document.getElementById('toggleSidebar').addEventListener('click', () => {
            document.getElementById('sidebar').classList.toggle('collapsed');
        });
    });
</script>
