@extends('layouts.member_master')

@section('title', __('dashboard.dashboard'))

@section('content')

    @if (session('profile_incomplete') && auth('member')->user()->status === 'new')
        <div class="alert alert-warning d-flex align-items-center gap-2 mb-4">
            <i class="bi bi-exclamation-triangle-fill"></i>
            <div>
                {{ session('profile_incomplete') }}
                <a href="{{ route('member.profile') }}" class="fw-bold text-decoration-underline">
                    {{ __('member.go_to_profile') }}
                </a>
            </div>
        </div>
    @endif


    <h3 class="mb-4">{{ __('member.welcome_back') }} {{ auth('member')->user()->name }}</h3>

    <div class="row g-4">

        <div class="col-md-4">
            <div class="card shadow-sm p-3">
                <h6>{{ __('footer.subscriptions') }}</h6>
                <strong>{{ auth('member')->user()->subscriptions()->count() }}</strong>
            </div>
        </div>



    </div>

@endsection
