@extends('layouts.member_master')

@section('title', __('member.member_offers'))

@section('content_member')


    <div class="container py-4">

        <h4 class="fw-bold mb-4">
            {{ __('member.available_offers') }}
        </h4>


        <div class="row g-4">

            
            @forelse ($offers as $offer)
                @php

                    $total = $offer->items->sum('final_price');
                @endphp

                <div class="col-md-6 col-lg-4">
                    <div class="card h-100 shadow-sm border-0">

                        <div class="card-body">

                            <h5 class="fw-bold mb-2">
                                {{ $offer->name['ar'] }}

                            </h5>

                            <ul class="list-unstyled small text-muted mb-3">
                                @foreach ($offer->items as $item)
                                    <li>✔ {{ $item->service_name }}</li>
                                @endforeach
                            </ul>

                            <div class="fw-bold fs-5 text-primary mb-3">
                                {{ $total }} 
                            </div>

                            <form method="POST" action="{{ route('member.subscribe', $offer->id) }}">
                                @csrf

                                <button type="submit" class="btn btn-success w-100">
                                    <i class="fa-solid fa-cart-plus"></i>
                                    {{ __('member.subscribe_now') }}
                                </button>
                            </form>


                        </div>
                    </div>
                </div>

            @empty
                <div class="col-12">
                    <div class="alert alert-info text-center">
                        {{ __('member.no_offers') }}
                    </div>
                </div>
            @endforelse

        </div>

    </div>

@endsection
