@extends('layouts.member_master')

@section('title', __('member.profile'))

@section('content')

    <div class="container-fluid">

        <h4 class="mb-4">{{ __('member.profile') }}</h4>

        {{-- Success Message --}}
        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif

        <div class="row g-4">

            {{-- 🧾 Basic Info --}}
            <div class="col-md-6">
                <div class="card shadow-sm p-4">
                    <h6 class="mb-3">{{ __('member.basic_info') }}</h6>

                    <form method="POST" action="{{ route('member.profile.update') }}">
                        @csrf

                        <div class="mb-3">
                            <label>{{ __('member.name') }}</label>
                            <input type="text" name="name" value="{{ old('name', $member->name) }}"
                                class="form-control @error('name') is-invalid @enderror">
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label>{{ __('member.phone') }}</label>
                            <input type="text" name="phone" value="{{ old('phone', $member->phone) }}"
                                class="form-control @error('phone') is-invalid @enderror">
                            @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label>{{ __('member.email') }}</label>
                            <input type="email" name="email" value="{{ old('email', $member->email) }}"
                                class="form-control @error('email') is-invalid @enderror">
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <button class="btn btn-primary">
                            {{ __('member.save_changes') }}
                        </button>
                    </form>
                </div>
            </div>

            {{-- 🔐 Change Password --}}
            <div class="col-md-6">
                <div class="card shadow-sm p-4">
                    <h6 class="mb-3">{{ __('member.change_password') }}</h6>

                    <form method="POST" action="{{ route('member.profile.password') }}">
                        @csrf



                        <div class="mb-3">
                            <label>{{ __('member.new_password') }}</label>
                            <input type="password" name="password"
                                class="form-control @error('password') is-invalid @enderror">
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label>{{ __('member.password_confirm') }}</label>
                            <input type="password" name="password_confirmation" class="form-control">
                        </div>

                        <button class="btn btn-warning">
                            {{ __('member.update_password') }}
                        </button>
                    </form>
                </div>
            </div>

        </div>
    </div>

@endsection
