@extends('layouts.member_master')

@section('title', __('member.my_subscriptions'))

@section('content_member')
    <div class="container py-4">

        <h4 class="fw-bold mb-4">
            <i class="fa-solid fa-id-card"></i>
            {{ __('member.my_subscriptions') }}
        </h4>

        {{-- Filters --}}
        <form method="GET" action="{{ route('member.my_subscriptions') }}" class="row g-2 mb-4">

            <div class="col-md-4">
                <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                    placeholder="{{ __('member.search_subscription') }}">
            </div>

            <div class="col-md-3">
                <select name="status" class="form-select">
                    <option value="">{{ __('member.all_status') }}</option>
                    <option value="active" @selected(request('status') == 'active')>
                        {{ __('member.active') }}
                    </option>
                    <option value="expired" @selected(request('status') == 'expired')>
                        {{ __('member.expired') }}
                    </option>
                </select>
            </div>

            <div class="col-md-3">
                <select name="sort" class="form-select">
                    <option value="latest">{{ __('member.latest') }}</option>
                    <option value="ending_soon" @selected(request('sort') == 'ending_soon')>
                        {{ __('member.ending_soon') }}
                    </option>
                </select>
            </div>

            <div class="col-md-2">
                <button class="btn btn-primary w-100">
                    <i class="fa-solid fa-filter"></i>
                    {{ __('member.filter') }}
                </button>
            </div>
        </form>

        {{-- Subscriptions --}}
        <div class="row g-4">
            @forelse($subscriptions as $sub)
                @php
                    $isExpired = now()->gt($sub->end_date);
                    $remaining = now()->diffInDays($sub->end_date, false);
                @endphp

                <div class="col-md-6 col-lg-4">
                    <div class="card h-100 shadow-sm border-0">

                        <div class="card-body">

                            <h5 class="fw-bold mb-2">
                                {{ $sub->item_name }}
                            </h5>

                            <span class="badge {{ $isExpired ? 'bg-danger' : 'bg-success' }}">
                                {{ $isExpired ? __('member.expired') : __('member.active') }}
                            </span>

                            <ul class="list-unstyled small mt-3">
                                <li>
                                    <i class="fa-regular fa-calendar"></i>
                                    {{ __('member.start_date') }}:
                                    {{ $sub->start_date->format('Y-m-d') }}
                                </li>

                                <li>
                                    <i class="fa-regular fa-calendar-check"></i>
                                    {{ __('member.end_date') }}:
                                    {{ $sub->end_date->format('Y-m-d') }}
                                </li>

                                <li>
                                    <i class="fa-solid fa-clock"></i>
                                    {{ __('member.duration') }}:
                                    {{ $sub->duration }} {{ __('member.days') }}
                                </li>
                            </ul>

                            <div class="d-flex justify-content-between align-items-center mt-3">
                                <strong class="text-primary">
                                    {{ number_format($sub->total, 2) }} SAR
                                </strong>

                                @if (!$isExpired)
                                    <span class="badge bg-info">
                                        {{ $remaining }} {{ __('member.days_left') }}
                                    </span>
                                @endif
                            </div>

                        </div>
                    </div>
                </div>

            @empty
                <div class="col-12">
                    <div class="alert alert-info text-center">
                        {{ __('member.no_subscriptions') }}
                    </div>
                </div>
            @endforelse
        </div>

        <div class="mt-4">
            {{ $subscriptions->withQueryString()->links() }}
        </div>

    </div>
@endsection
