@extends('layouts.master')
@section('title', 'تقرير مبيعات فواتير الخدمات')

@section('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <style>
        .card-flat {
            background: #0f2233;
            border-radius: 14px;
            border: 1px solid #1e3b4d;
            padding: 16px;
            color: #eaf4ff
        }

        .stat {
            border-radius: 14px;
            padding: 14px;
            color: #fff
        }
    </style>
@endsection

@section('content')

    <h3 class="fw-bold text-light mb-3">
        <i class="fas fa-chart-line text-success me-2"></i>
        تقرير مبيعات فواتير الخدمات
    </h3>

    <div class="row g-3 mb-3" id="statsArea">
        <div class="col-md-3">
            <div class="stat bg-primary">
                <div>عدد الفواتير</div>
                <h4 id="st_count">0</h4>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat bg-success">
                <div>إجمالي الصافي</div>
                <h4 id="st_net">0.00</h4>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat bg-warning">
                <div>إجمالي الضريبة</div>
                <h4 id="st_tax">0.00</h4>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat bg-danger">
                <div>إجمالي الخصومات</div>
                <h4 id="st_discount">0.00</h4>
            </div>
        </div>
    </div>

    <div class="card-flat mb-3">
        <div class="row g-3 align-items-end">
            <div class="col-md-4">
                <label class="form-label">من تاريخ</label>
                <input type="date" id="date_from" class="form-control">
            </div>
            <div class="col-md-4">
                <label class="form-label">إلى تاريخ</label>
                <input type="date" id="date_to" class="form-control">
            </div>
            <div class="col-md-4">
                <label class="form-label">الفرع</label>
                <select id="branch_id" class="form-select">
                    <option value="">الكل</option>
                    @foreach ($branches as $b)
                        <option value="{{ $b->id }}">{{ $b->name }}</option>
                    @endforeach
                </select>
            </div>


            <div class="col-md-12 d-flex gap-2 justify-content-end mt-2">
                <button type="button" class="btn btn-secondary" id="btnReset">استعادة الفلاتر</button>
                <button type="button" class="btn btn-success" id="btnPrint">🖨 طباعة التقرير</button>
            </div>
        </div>
    </div>

    <div class="card-flat">
        <table id="reportTable" class="table table-dark table-bordered text-center align-middle mb-0">
            <thead>
                <tr>
                    <th>#</th>

                    <th>رقم الفاتورة</th>
                    <th>العضو</th>
                    <th>الفرع</th>

                    <th>الصافي</th>
                </tr>
            </thead>
        </table>
    </div>

@endsection

@section('js')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

    <script>
        let table = null;

        function getFilters() {
            return {
                date_from: $('#date_from').val(),
                date_to: $('#date_to').val(),
                branch_id: $('#branch_id').val(),

            };
        }

        function loadStats() {
            $.get("{{ route('reports.service-invoices.stats') }}", getFilters())
                .done(function(res) {
                    $('#st_count').text(res.count ?? 0);
                    $('#st_net').text(Number(res.sum_net ?? 0).toFixed(2));
                    $('#st_tax').text(Number(res.sum_tax ?? 0).toFixed(2));
                    $('#st_discount').text(Number(res.sum_discount ?? 0).toFixed(2));
                })
                .fail(function(xhr) {
                    console.log('Stats error:', xhr.responseText);
                });
        }

        function reloadAll() {
            if (table) table.ajax.reload(null, false);
            loadStats();
        }

        $(function() {
            table = $('#reportTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('reports.service-invoices.data') }}",
                    data: function(d) {
                        Object.assign(d, getFilters());
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },

                    {
                        data: 'invoice_no',
                        name: 'invoice_no'
                    },
                    {
                        data: 'member_name',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'branch_name',
                        orderable: false,
                        searchable: false
                    },

                    {
                        data: 'total_net',
                        name: 'total_net',
                        render: (v) => `<b class="text-success">${v}</b>`
                    },
                ],
                order: [
                    [1, 'desc']
                ],
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.13.6/i18n/ar.json"
                }
            });

            $('#date_from,#date_to,#branch_id,#provider_user_id').on('change', reloadAll);

            $('#btnReset').on('click', function() {
                $('#date_from').val('');
                $('#date_to').val('');
                $('#branch_id').val('');
                $('#provider_user_id').val('');
                reloadAll();
            });

            $('#btnPrint').on('click', function() {
                // نطبع من صفحة مخصصة للطباعة (زي Excel/Word)
                const q = new URLSearchParams(getFilters()).toString();
                const url = "{{ route('reports.service-invoices.print') }}" + "?" + q;
                window.open(url, '_blank');
            });

            reloadAll();
        });
    </script>
@endsection
