<!doctype html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="utf-8">
    <title>تقرير مبيعات فواتير الخدمات</title>
    <style>
        body {
            font-family: Arial, Tahoma;
            margin: 20px;
            color: #000
        }

        h2 {
            margin: 0 0 6px 0;
            text-align: center
        }

        .sub {
            font-size: 13px;
            text-align: center;
            margin: 0 0 16px 0
        }

        table {
            border-collapse: collapse;
            width: 100%;
            font-size: 13px
        }

        th,
        td {
            border: 1px solid #000;
            padding: 6px;
            text-align: center
        }

        th {
            background: #f0f0f0
        }

        .summary {
            width: 40%;
            margin-top: 14px;
            float: left
        }

        @media print {
            .no-print {
                display: none
            }
        }
    </style>
</head>

<body>

    <div class="no-print" style="text-align:left;margin-bottom:10px">
        <button onclick="window.print()">طباعة</button>
    </div>

    <h2>تقرير مبيعات فواتير الخدمات</h2>
    <p class="sub">من: {{ $from ?: '—' }} &nbsp;&nbsp; إلى: {{ $to ?: '—' }}</p>

    <table>
        <thead>
            <tr>
                <th>#</th>
          
                <th>رقم الفاتورة</th>
                <th>العضو</th>
                <th>الفرع</th>
            
                <th>الصافي</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($rows as $i => $r)
                <tr>
                    <td>{{ $i + 1 }}</td>
              
                    <td>{{ $r->invoice_no }}</td>
                    <td>{{ $r->member->name ?? '—' }}</td>
                    <td>{{ $r->branch->name ?? '—' }}</td>
                
                    <td>{{ number_format((float) $r->total_net, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <table class="summary">
        <tr>
            <th>عدد الفواتير</th>
            <td>{{ $stats['count'] }}</td>
        </tr>
        <tr>
            <th>إجمالي الصافي</th>
            <td>{{ number_format($stats['sum_net'], 2) }}</td>
        </tr>
        <tr>
            <th>إجمالي الضريبة</th>
            <td>{{ number_format($stats['sum_tax'], 2) }}</td>
        </tr>
        <tr>
            <th>إجمالي الخصومات</th>
            <td>{{ number_format($stats['sum_discount'], 2) }}</td>
        </tr>
    </table>

    <script>
        // طباعة تلقائي
        window.onload = function() {
            window.print();
        }
    </script>
</body>

</html>
