<!doctype html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="utf-8">
    <title>تقرير مبيعات الاشتراكات</title>
    <style>
        body {
            font-family: Arial;
            margin: 20px
        }

        table {
            border-collapse: collapse;
            width: 100%
        }

        th,
        td {
            border: 1px solid #000;
            padding: 6px;
            text-align: center
        }

        th {
            background: #f0f0f0
        }
    </style>
</head>

<body onload="window.print()">

    <h2 style="text-align:center">تقرير مبيعات الاشتراكات</h2>
    <p style="text-align:center">من {{ $from ?: '—' }} إلى {{ $to ?: '—' }}</p>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>فاتورة</th>
                <th>العضو</th>
                <th>الفرع</th>

                <th>الإجمالي</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($rows as $i => $r)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td>{{ $r->invoice_no }}</td>
                    <td>{{ $r->member->name ?? '—' }}</td>
                    <td>{{ $r->branch->name ?? '—' }}</td>

                    <td>{{ number_format($r->total, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <br>
    <table style="width:40%">
        <tr>
            <th>عدد</th>
            <td>{{ $stats['count'] }}</td>
        </tr>
        <tr>
            <th>إجمالي</th>
            <td>{{ number_format($stats['sum'], 2) }}</td>
        </tr>
        <tr>
            <th>ضريبة</th>
            <td>{{ number_format($stats['tax'], 2) }}</td>
        </tr>
        <tr>
            <th>خصم</th>
            <td>{{ number_format($stats['discount'], 2) }}</td>
        </tr>
    </table>

</body>

</html>
