@extends('layouts.master')
@section('title', 'تقرير مبيعات الاشتراكات')

@section('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

    <style>
        .card-flat {
            background: #0f2233;
            border-radius: 14px;
            border: 1px solid #1e3b4d;
            padding: 16px;
            color: #eaf4ff
        }

        .stat {
            border-radius: 14px;
            padding: 14px;
            color: #fff
        }
    </style>
@endsection

@section('content')

    <h3 class="fw-bold mb-3">
        <i class="fas fa-chart-line text-success me-2"></i>
        تقرير مبيعات الاشتراكات
    </h3>

    {{-- الإحصائيات --}}
    <div class="row g-3 mb-3">
        <div class="col-md-3 ">
            <div class="card p-3 bg-primary">عدد الاشتراكات <h4 id="st_count">0</h4>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card p-3 bg-success">الإجمالي <h4 id="st_sum">0</h4>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card p-3 bg-success">الضريبة <h4 id="st_tax">0</h4>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card p-3 bg-warning">الخصم <h4 id="st_discount">0</h4>
            </div>
        </div>
    </div>

    {{-- الفلاتر --}}
    <div class="card p-3 mb-3">
        <div class="row g-3">
            <div class="col-md-4"><input type="date" id="date_from" class="form-control"></div>
            <div class="col-md-4"><input type="date" id="date_to" class="form-control"></div>

            <div class="col-md-4">
                <select id="branch_id" class="form-select">
                    <option value="">كل الفروع</option>
                    @foreach ($branches as $b)
                        <option value="{{ $b->id }}">{{ $b->name }}</option>
                    @endforeach
                </select>
            </div>



            <div class="col-md-12 d-flex justify-content-end gap-2">
                <button id="btnReset" class="btn btn-secondary">استعادة</button>
                <button id="btnPrint" class="btn btn-success">🖨 طباعة التقرير</button>
            </div>
        </div>
    </div>

    {{-- الجدول --}}
    <div class="card">
        <table id="subsTable" class="table table-bordered text-center">
            <thead>
                <tr>
                    <th>#</th>
                    <th>رقم الفاتورة</th>
                    <th>العضو</th>
                    <th>الفرع</th>

                    <th>الإجمالي</th>
                </tr>
            </thead>
        </table>
    </div>

@endsection

@section('js')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <script>
        let table;

        function filters() {
            return {
                date_from: $('#date_from').val(),
                date_to: $('#date_to').val(),
                branch_id: $('#branch_id').val(),

            }
        }

        function loadStats() {
            $.get("{{ route('reports.subscriptions.stats') }}", filters(), r => {
                $('#st_count').text(r.count);
                $('#st_sum').text(r.sum.toFixed(2));
                $('#st_tax').text(r.tax.toFixed(2));
                $('#st_discount').text(r.discount.toFixed(2));
            });
        }

        $(function() {
            table = $('#subsTable').DataTable({
                serverSide: true,
                ajax: {
                    url: "{{ route('reports.subscriptions.data') }}",
                    data: d => Object.assign(d, filters())
                },
                columns: [{
                        data: 'DT_RowIndex',
                        orderable: false
                    },
                    {
                        data: 'invoice_no'
                    },
                    {
                        data: 'member_name'
                    },
                    {
                        data: 'branch_name'
                    },

                    {
                        data: 'total'
                    }
                ]
            });

            $('#date_from,#date_to,#branch_id,#created_by').on('change', () => {
                table.ajax.reload();
                loadStats();
            });

            $('#btnReset').on('click', () => {
                $('input,select').val('');
                table.ajax.reload();
                loadStats();
            });

            $('#btnPrint').on('click', () => {
                const q = new URLSearchParams(filters()).toString();
                window.open("{{ route('reports.subscriptions.print') }}?" + q, '_blank');
            });

            loadStats();
        });
    </script>
@endsection
