<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use App\Models\Subscription;
use App\Models\Offer;
use App\Models\Service;
use App\Models\Member;
use App\Models\CompanySetting;
use Illuminate\Http\Request;

// Controllers
use App\Http\Controllers\{
    UserController,
    RoleController,
    PermissionController,
    BranchController,

    BranchTypeController,
    BranchCategoryController,
    CountryController,
    StateController,
    CityController,
    ServiceController,
    ServiceCategoryController,
    ServiceTypeController,
    CustomerController,
    MemberController,
    OfferController,
    CompanySettingController,
    SubscriptionController,
    ServiceInvoiceController,
    PaymentController,
    ReportController
};


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
| هنا تُسجَّل جميع مسارات الويب الخاصة بالتطبيق.
| كل مجموعة مسارات (مثل الإدارة) يتم ترتيبها حسب الأولوية والوظيفة.
|--------------------------------------------------------------------------
*/

/*
        |--------------------------------------------------------------------------
        | 🏠 الصفحة الرئيسية
        |--------------------------------------------------------------------------
        */



Route::get('member/payment/result', [PaymentController::class, 'result'])
    ->name('member.payment.result');



Route::group(
    [
        'prefix' => LaravelLocalization::setLocale(),
        'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath'],
    ],
    function () {
        /*
        |---------------------------------------------
        | FRONT ROUTES
        |---------------------------------------------
        */



        Route::get('/', fn() => view('frontEnd.home'))->name('home');

        Route::get('/subscriptionss', function () {

            $subscriptions = Subscription::all()->map(function ($sub) {

                // --- 1) اسم المشترك ---
                $sub->subscriber_name = $sub->member->name ?? 'مشترك غير معروف';

                // --- 2) تجهيز الخدمات ---
                if ($sub->subscription_type === 'service') {

                    // جلب الخدمة من جدول الخدمات
                    $service = \App\Models\Service::find($sub->item_id);

                    if ($service) {
                        $sub->items_data = collect([[
                            'name' => $service->getTranslation('name', 'ar'),
                            'price' => $service->price,
                            'duration_value' => $service->duration_value,
                            'duration_unit' => $service->duration_unit,
                        ]]);
                    } else {
                        $sub->items_data = collect([]);
                    }
                } else {

                    // --- لو عرض ---
                    // مثال: جدول offer_items
                    $offerItems = \App\Models\OfferItem::where('offer_id', $sub->item_id)->get();

                    $sub->items_data = $offerItems->map(function ($i) {
                        return [
                            'name' => $i->service_name,
                            'price' => $i->final_price,
                            'duration_value' => $i->final_duration_value,
                            'duration_unit' => $i->final_duration_unit,
                        ];
                    });
                }

                // --- 3) السعر ---
                $sub->total_price =
                    $sub->items_data->sum('price') ?: $sub->total ?: $sub->price;

                return $sub;
            });

            return view('frontEnd.subscriptions', compact('subscriptions'));
        })->name('Front_subscriptions');


        Route::get('/offerss', function () {
            $offers = Offer::with('items')->get();
            foreach ($offers as $offer) {
                $offer->calculated_total = $offer->items->sum('final_price');
            }
            return view('frontEnd.offers', compact('offers'));
        })->name('Front_offers');

        Route::get('/servicess', function () {
            $services = Service::where('active', 1)->get();
            return view('frontEnd.services', compact('services'));
        })->name('Front_services');


        Route::get('/about', fn() => view('frontEnd.about'))->name('Front_about');



        /*
|--------------------------------------------------------------------------
| 👤 MEMBER AUTH (WEB)
|--------------------------------------------------------------------------
*/

        Route::get('/member/register', [MemberController::class, 'registerForm'])
            ->name('member.register.form');

        Route::post('/member/register', [MemberController::class, 'register'])
            ->name('member.register');

        Route::get('/member/login', [MemberController::class, 'loginForm'])
            ->name('member.login.form');

        Route::post('/member/login', [MemberController::class, 'login'])
            ->name('member.login');

        Route::post('/member/logout', [MemberController::class, 'logout'])
            ->name('member.logout');

        Route::post('/member/check-email', function (Request $request) {
            return response()->json([
                'exists' => Member::where('email', $request->email)->exists()
            ]);
        })->name('member.check.email');



        Route::middleware('auth:member')->group(function () {

            Route::get('/member/dashboard', [MemberController::class, 'dashboard'])
                ->name('member.dashboard');

            Route::get('/member/subscriptions', [MemberController::class, 'subscriptions'])
                ->name('member.subscriptions');

            // عرض الملف الشخصي
            Route::get('/member/profile', [MemberController::class, 'profile'])
                ->name('member.profile');

            // تحديث البيانات
            Route::post('/member/profile', [MemberController::class, 'updateProfile'])
                ->name('member.profile.update');

            // تغيير كلمة المرور
            Route::post('/member/profile/password', [MemberController::class, 'updatePassword'])
                ->name('member.profile.password');

            Route::get('/member/offers', [OfferController::class, 'memberOffers'])
                ->name('offersMember');
            Route::post('/offers/{offer}/subscribe', [OfferController::class, 'subscribe'])
                ->name('member.offers.subscribe');

            Route::post('/member/subscribe/{offer}', [PaymentController::class, 'start'])
                ->name('member.subscribe');


            Route::get('/member/payment/{payment}', [PaymentController::class, 'checkout'])
                ->name('member.payment.checkout');


            Route::get('/member/my_subscriptions', [PaymentController::class, 'my_subscriptions'])
                ->name('member.my_subscriptions');



            // عرض الباقات للعضو
            Route::get('/member/packages', [OfferController::class, 'packages'])
                ->name('member.packages');

            // بدء الاشتراك في خدمة داخل باقة
            Route::post('/member/subscribe/service/{offerItem}', [PaymentController::class, 'startService'])
                ->name('member.subscribe.service');
        });




        // =======================
        // ADMIN ROUTES (your code)
        // =======================

        /*
        |--------------------------------------------------------------------------
        | 🔐 مسارات تسجيل الدخول / الخروج
        |--------------------------------------------------------------------------
        */
        Route::get('/admin/login', [UserController::class, 'loginForm'])->name('admin.loginForm');
        Route::post('/admin/login', [UserController::class, 'login'])->name('admin.login');
        Route::post('/admin/logout', [UserController::class, 'logout'])->name('admin.logout');

        /*
        |--------------------------------------------------------------------------
        | 🧭 لوحة التحكم (Dashboard)
        |--------------------------------------------------------------------------
        */
        Route::middleware('auth:web')->group(function () {

            // Route::get('/admin/dashboard', fn() => view('admin.dashboard'))->name('admin.dashboard');

            Route::get('/admin/dashboard', function () {
                $company = CompanySetting::first(); // أو where('id',1)
                return view('admin.dashboard', compact('company'));
            })->name('admin.dashboard');

            /*
            |--------------------------------------------------------------------------
            | 🌍 العناوين (Countries / States / Cities)
            |--------------------------------------------------------------------------
            */
            Route::resource('countries', CountryController::class)->only(['index', 'store', 'update']);
            Route::resource('states', StateController::class)->only(['index', 'store', 'update']);
            Route::resource('cities', CityController::class)->only(['index', 'store', 'update']);
            Route::post('cities/store', [CityController::class, 'CityState'])->name('CityState');

            // AJAX: إرجاع المدن حسب الدولة
            Route::get('get-states/{country_id}', function ($country_id) {
                $locale = app()->getLocale();
                $states = \App\Models\State::where('country_id', $country_id)
                    ->get()
                    ->map(fn($s) => [
                        'id' => $s->id,
                        'name' => $s->getTranslation('name', $locale),
                    ]);
                return response()->json($states);
            });

            /*
            |--------------------------------------------------------------------------
            | 🏢 الفروع Branches
            |--------------------------------------------------------------------------
            */
            Route::resource('branch-categories', BranchCategoryController::class);
            Route::resource('branch-types', BranchTypeController::class);
            Route::resource('branches', BranchController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);

            // أهداف الفروع
            Route::get('branches/{branch}/goals', [BranchController::class, 'goals'])->name('branches.goals');
            Route::post('branches/{branch}/goals', [BranchController::class, 'saveGoals'])->name('branches.goals.save');

            /*
            |--------------------------------------------------------------------------
            | 🧾 الخدمات (Services)
            |--------------------------------------------------------------------------
            */
            Route::resource('service-types', ServiceTypeController::class)->only(['index', 'create', 'store', 'edit', 'update', 'show']);
            Route::resource('service-categories', ServiceCategoryController::class)->only(['index', 'create', 'store', 'edit', 'update', 'show']);
            Route::resource('services', ServiceController::class)->only(['index', 'create', 'store', 'edit', 'update', 'show']);

            /*
            |--------------------------------------------------------------------------
            | 👥 العملاء والعملاء الداخليين
            |--------------------------------------------------------------------------
            */
            Route::get('customers/predict-code', [CustomerController::class, 'predictCode'])->name('customers.predict');
            Route::resource('customers', CustomerController::class)->except(['destroy']);

            Route::get('members/predict-code', [MemberController::class, 'predictCode'])->name('members.predict');
            Route::post('members/upload', [MemberController::class, 'upload'])->name('members.upload');
            Route::delete('members/upload', [MemberController::class, 'deleteUpload'])->name('members.upload.delete');
            Route::resource('members', MemberController::class)->except(['destroy']);

            Route::post(
                'members/{member}/toggle-status',
                [MemberController::class, 'toggleStatus']
            )->name('members.toggle-status');

            /*
            |--------------------------------------------------------------------------
            | 💰 العروض Offers
            |--------------------------------------------------------------------------
            */
            Route::resource('offers', OfferController::class)->except(['destroy']);
            Route::get('offers/service-info/{service}', [OfferController::class, 'serviceInfo'])->name('offers.service-info');
            Route::patch('/offers/{offer}/toggle-active', [OfferController::class, 'toggleActive'])
                ->name('offers.toggle-active');


            /*
            |--------------------------------------------------------------------------
            | ⚙️ الإعدادات Settings
            |--------------------------------------------------------------------------
            */
            Route::get('settings/company', [CompanySettingController::class, 'edit'])->name('settings.company.edit');
            Route::post('settings/company', [CompanySettingController::class, 'update'])->name('settings.company.update');

            /*
            |--------------------------------------------------------------------------
            | 🔑 الصلاحيات والأدوار والمستخدمين
            |--------------------------------------------------------------------------
            */
            Route::get('permissions/list', [PermissionController::class, 'list'])->name('permissions.list');
            Route::resource('permissions', PermissionController::class)->except(['show']);

            Route::get('roles/list', [RoleController::class, 'list'])->name('roles.list');
            Route::resource('roles', RoleController::class)->except(['show']);

            Route::get('users/list', [UserController::class, 'list'])->name('users.list');
            Route::resource('users', UserController::class)->except(['show']);

            // ✅ المسار الافتراضي داخل النظام الإداري
            // Route::get('/', fn() => redirect()->route('roles.index'));

            /*
            |--------------------------------------------------------------------------
            | 🔑   الاشتراكات
            |--------------------------------------------------------------------------
            */

            Route::get('/subscriptions', [SubscriptionController::class, 'index'])->name('subscriptions.index');
            Route::get('/subscriptions/create', [SubscriptionController::class, 'create'])->name('subscriptions.create');
            Route::post('/subscriptions', [SubscriptionController::class, 'store'])->name('subscriptions.store');
            Route::get('/subscriptions/toggle/{id}', [SubscriptionController::class, 'toggle'])->name('subscriptions.toggle');
            Route::get('/branches/{id}/members', [SubscriptionController::class, 'getMembers']);
            Route::get('/members/{id}/info', [SubscriptionController::class, 'getMemberInfo']);
            Route::get('/offers/{id}/services', [SubscriptionController::class, 'getOfferServices']);
            Route::get('/subscriptions/{sub}/invoice', [SubscriptionController::class, 'invoice'])
                ->name('subscriptions.invoice');
            Route::post('subscriptions/{id}/status', [SubscriptionController::class, 'updateStatus'])
                ->name('subscriptions.updateStatus');
            Route::post('/subscriptions/bulk-status', [SubscriptionController::class, 'bulkStatus']);
            Route::get('/subscriptions/print-multi', [SubscriptionController::class, 'printMulti']);
            Route::get('/subscriptions/show/{id}', [SubscriptionController::class, 'show'])->name('subscriptions.show');
            Route::get('subscriptions/{id}/card', [SubscriptionController::class, 'card'])->name('subscriptions.card');
            /*
            |--------------------------------------------------------------------------
            | 🔑   طرق الدفع
            |--------------------------------------------------------------------------
            */
            Route::resource('payment-methods', \App\Http\Controllers\PaymentMethodController::class)
                ->only(['index', 'store', 'destroy']);


            /*
            |--------------------------------------------------------------------------
            | فواتير الخدمات
            |--------------------------------------------------------------------------
            */
            Route::resource('service-invoices', ServiceInvoiceController::class);

            // جلب بيانات خدمة لـ Select2 (اختياري لو هتستخدم AJAX)
            Route::get('api/services/search', [ServiceInvoiceController::class, 'searchServices'])
                ->name('api.services.search');

            // إضافة عضو من المودال (AJAX)
            Route::post('api/members/quick-store', [ServiceInvoiceController::class, 'quickStoreMember'])
                ->name('api.members.quick-store');

            Route::get('/get-all-members', function () {
                return Member::select('id', 'name', 'status')
                    ->withCount('subscriptions')
                    ->get()
                    ->map(function ($m) {
                        return [
                            'id' => $m->id,
                            'name' => $m->name,
                            'status' => $m->status,
                            'subscriptions_count' => $m->subscriptions_count ?? 0,
                        ];
                    });
            });




            Route::get('/service-invoices/get-members/{branchId}', [ServiceInvoiceController::class, 'getMembers'])->name('members.by-branch');
            Route::get('/service-invoices/get-offer-services/{offerId}', [ServiceInvoiceController::class, 'getOfferServices']);




            Route::get('service-invoices/{id}/print', [ServiceInvoiceController::class, 'print'])
                ->name('service-invoices.print');



            // reports -----
            Route::get('/reports/service-invoices', [ReportController::class, 'serviceInvoicesReport'])
                ->name('reports.service-invoices');

            Route::get('/reports/service-invoices/data', [ReportController::class, 'serviceInvoicesData'])
                ->name('reports.service-invoices.data');

            Route::get('/reports/service-invoices/stats', [ReportController::class, 'serviceInvoicesStats'])
                ->name('reports.service-invoices.stats');

            Route::get('/reports/service-invoices/print', [ReportController::class, 'serviceInvoicesPrint'])
                ->name('reports.service-invoices.print');



            Route::get('/reports/subscriptions', [ReportController::class, 'index'])
                ->name('reports.subscriptions');

            Route::get('/reports/subscriptions/data', [ReportController::class, 'data'])
                ->name('reports.subscriptions.data');

            Route::get('/reports/subscriptions/stats', [ReportController::class, 'stats'])
                ->name('reports.subscriptions.stats');

            Route::get('/reports/subscriptions/print', [ReportController::class, 'print'])
                ->name('reports.subscriptions.print');
        });

        /*
        |--------------------------------------------------------------------------
        | 🌐 تغيير اللغة
        |--------------------------------------------------------------------------
        */
        Route::get('/change-language/{locale}', function ($locale) {
            LaravelLocalization::setLocale($locale);
            return redirect()->back();
        })->name('change-language');
    }
);

// ✅ Laravel Auth الافتراضي
Auth::routes();

// صفحات تجريبية (إن وُجدت)
Route::get('/home1', [App\Http\Controllers\HomeController::class, 'index'])->name('home1');
Route::get('/home2', [App\Http\Controllers\HomeController::class, 'index1'])->name('home2');
