<header>
    <nav class="navbar navbar-expand-lg custom-navbar">
        <div class="container">

            <!-- Logo -->
            <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(asset('front_assets/imge/logo 1.png')); ?>" class="nav-logo" alt="Logo" />
            </a>

            <!-- Mobile Toggle -->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
                <i class="bi bi-list text-light fs-1"></i>
            </button>

            <!-- Menu -->
            <div class="collapse navbar-collapse" id="mainNavbar">

                <ul class="navbar-nav mx-auto mb-2 mb-lg-0 text-center">

                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('home') ? 'active-link' : ''); ?>"
                            href="<?php echo e(route('home')); ?>">
                            <?php echo e(__('nav.home')); ?>

                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('Front_subscriptions') ? 'active-link' : ''); ?>"
                            href="<?php echo e(route('Front_subscriptions')); ?>">
                            <?php echo e(__('nav.subscriptions')); ?>

                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('Front_offers') ? 'active-link' : ''); ?>"
                            href="<?php echo e(route('Front_offers')); ?>">
                            <?php echo e(__('nav.offers')); ?>

                        </a>
                    </li>

                    <li class="nav-item d-none">
                        <a class="nav-link <?php echo e(request()->routeIs('Front_services') ? 'active-link' : ''); ?>"
                            href="<?php echo e(route('Front_services')); ?>">
                            <?php echo e(__('nav.services')); ?>

                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('Front_about') ? 'active-link' : ''); ?>"
                            href="<?php echo e(route('Front_about')); ?>">
                            <?php echo e(__('nav.about')); ?>

                        </a>
                    </li>


                    <?php if(LaravelLocalization::getCurrentLocale() == 'ar'): ?>
                        <li class="nav-item lang-switch">
                            <span class="lang-btn active">عربي</span>
                        </li>

                        <li class="nav-item lang-divider">|</li>

                        <li class="nav-item lang-switch">
                            <a class="lang-btn"
                                href="<?php echo e(LaravelLocalization::getLocalizedURL('en', null, [], true)); ?>">
                                EN
                            </a>
                        </li>
                    <?php else: ?>
                        <li class="nav-item lang-switch">
                            <span class="lang-btn active">EN</span>
                        </li>
                        <li class="nav-item lang-divider">|</li>

                        <li class="nav-item lang-switch">
                            <a class="lang-btn"
                                href="<?php echo e(LaravelLocalization::getLocalizedURL('ar', null, [], true)); ?>">
                                عربي
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>


                <div class="d-flex align-items-center gap-2 auth-buttons">

                    <?php if(auth()->guard('member')->check()): ?>
                        <!-- 👤 Logged In Member -->
                        <div class="dropdown">
                            <button class="btn btn-outline-light dropdown-toggle" type="button" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                <i class="bi bi-person-circle"></i>
                                <?php echo e(auth('member')->user()->name); ?>

                            </button>

                            <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                    <a class="dropdown-item" href="<?php echo e(route('member.dashboard')); ?>">
                                        <i class="bi bi-speedometer2"></i>
                                        <?php echo e(__('dashboard.dashboard')); ?>

                                    </a>
                                </li>

                                <li>
                                    <a class="dropdown-item" href="<?php echo e(route('member.profile')); ?>">
                                        <i class="bi bi-person"></i>
                                        <?php echo e(__('dashboard.profile')); ?>

                                    </a>
                                </li>

                                <li>
                                    <hr class="dropdown-divider">
                                </li>

                                <li>
                                    <form method="POST" action="<?php echo e(route('member.logout')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="dropdown-item text-danger">
                                            <i class="bi bi-box-arrow-right"></i>
                                            <?php echo e(__('auth.logout')); ?>

                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>


                    <?php if(auth()->guard('member')->guest()): ?>
                        <!-- 🔐 Guest -->
                        <a href="<?php echo e(route('member.login.form')); ?>" class="btn btn-outline-light">
                            <?php echo e(__('auth.login')); ?>

                        </a>

                        <a href="<?php echo e(route('member.register.form') ?? '#'); ?>" class="btn btn-warning">
                            <?php echo e(__('auth.register')); ?>

                        </a>
                    <?php endif; ?>

                </div>



            </div>

        </div>
    </nav>

    <!-- HERO Section -->
    <section class="hero-section">

        <div class="hero-images">
            <img src="<?php echo e(asset('front_assets/imge/bg header 1.png')); ?>" class="hero-image hero-back" alt="">
            <img src="<?php echo e(asset('front_assets/imge/bg header 2.png')); ?>" class="hero-image hero-front" alt="">
        </div>

        <p class="hero-description">
            <?php echo e(__('nav.desc')); ?>

        </p>

    </section>
</header>
<?php /**PATH E:\xampp\htdocs\shapooov\resources\views/frontEnd/layouts/Fheader.blade.php ENDPATH**/ ?>