<?php
    $logo =
        $company && $company->logo_path && file_exists(public_path($company->logo_path))
            ? asset($company->logo_path)
            : asset('assets/dashboard.jpg');
?>

<style>
    .user-img img {
        background: transparent !important;
    }
</style>


<header class="page-header row">
    <div class="logo-wrapper d-flex align-items-center col-auto">
        <!-- Logo -->
        <a href="#">
            <img class="light-logo img-fluid rounded-circle" src="<?php echo e($logo); ?>" alt="logo">
            <img class="dark-logo img-fluid rounded-circle" src="<?php echo e($logo); ?>" alt="logo">
        </a>
        <!-- Close Button -->
        <a class="close-btn toggle-sidebar" href="javascript:void(0)">
            <i class="fas fa-bars colored"></i> <!-- FontAwesome Menu Icon -->
        </a>
    </div>
    <div class="page-main-header col">
        <div class="header-left">
            <?php if(auth()->check() && auth()->user()?->branch): ?>
                <span class="badge bg-primary px-3 py-2 shadow-sm">
                    <i class="fas fa-building me-1"></i>
                    <?php echo e(optional(auth()->user()?->branch)->getTranslation('name', app()->getLocale()) ?? ''); ?>

                </span>
            <?php else: ?>
            <?php endif; ?>
        </div>

        <div class="nav-right">
            <ul class="header-right">
                <!-- Language Dropdown -->
                <li class="custom-dropdown">
                    <div class="translate_wrapper">
                        <div class="current_lang">
                            <a class="lang" href="javascript:void(0)" id="languageDropdown" role="button"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                <span class="lang-txt f-w-900 text-uppercase "> <i
                                        class="fas fa-globe  mx-2 "></i><?php echo e(app()->getLocale()); ?> </span>
                            </a>

                        </div>
                        <ul class="custom-menu profile-menu language-menu py-0 more_lang">

                            <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($localeCode !== app()->getLocale()): ?>
                                    <li class="d-block"><a class="lang d-flex align-middle"
                                            href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>"
                                            data-value="<?php echo e($properties['name']); ?>">
                                            <i class="fas fa-globe mx-1 colored"></i>
                                            <span class="lang-txt f-w-700 "> <?php echo e($properties['name']); ?></span>

                                        </a></li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ul>
                    </div>
                </li>
                <!-- Search (Mobile) -->

                <!-- Dark Mode -->
                <li>
                    <a class="dark-mode" href="javascript:void(0)">

                        <i class="fas fa-moon colored"></i> <!-- FontAwesome Moon Icon -->
                    </a>
                </li>
                <!-- Cart -->

                <!-- Notifications -->
                
                <!-- Full Screen -->
                <li>
                    <a class="full-screen" href="javascript:void(0)">
                        <i class="fas fa-expand colored"></i> <!-- FontAwesome Expand Icon -->
                    </a>
                </li>
                <!-- User Profile -->
                <li class="profile-nav custom-dropdown">
                    <div class="user-wrap">
                        
                        <div class="user-img ">
                            <img src="<?php echo e(asset($company?->logo_path ?? 'assets/dashboard.jpg')); ?>" alt="user">
                        </div>

                        <div class="user-content">
                            <h6><?php echo e(auth()->user()->name ?? ''); ?></h6>
                            <p class="mb-0"><?php echo e(auth()->user()->name ?? ''); ?><i
                                    class="fas fa-chevron-down colored"></i></p>
                            <!-- FontAwesome Dropdown Icon -->
                        </div>
                    </div>


                    <div class="custom-menu overflow-hidden">
                        <ul class="profile-body">
                            
                            <li class="d-flex align-items-center">

                                <i class="fas fa-sign-out-alt text-danger me-2"></i>

                                
                                <?php if(auth()->guard('web')->check()): ?>
                                    <form method="POST" action="<?php echo e(route('admin.logout')); ?>" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-link dropdown-item text-danger p-0">
                                            <?php echo e(__('messages.log_out')); ?>

                                        </button>
                                    </form>
                                <?php endif; ?>

                                
                                <?php if(auth()->guard('member')->check()): ?>
                                    <form method="POST" action="<?php echo e(route('member.logout')); ?>" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-link dropdown-item text-danger p-0">
                                            <?php echo e(__('messages.log_out')); ?>

                                        </button>
                                    </form>
                                <?php endif; ?>

                            </li>


                        </ul>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</header>
<?php /**PATH E:\xampp\htdocs\shapooov\resources\views/layouts/header.blade.php ENDPATH**/ ?>