

<?php
    $isEdit = isset($member);
    $action = $isEdit ? route('members.update', $member) : route('members.store');
?>

<?php $__env->startSection('title', $isEdit ? 'تعديل عضو' : 'إضافة عضو'); ?>
<?php $__env->startSection('pages'); ?> <?php echo e(__('dashboard.home')); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <style>
        .card-section {
            background: #0f1e2b;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 16px
        }

        .tabs-sticky {
            position: sticky;
            top: 60px;
            z-index: 8
        }

        .tabs-sticky .nav-tabs {
            background: #0f1e2b;
            border-radius: 12px;
            padding: 6px
        }

        .img-thumb {
            max-height: 80px;
            border-radius: 8px
        }
    </style>

    <style>
        :root {
            --u-bg: #0b1621;
            --u-panel: #0d1b27;
            --u-dash: #28465e;
            --u-fg: #cfe7ff;
            --u-sub: #8fb7d6;
            --u-ok: #22c55e;
            --u-err: #ef4444;
            --u-grad: linear-gradient(135deg, #06b6d4 0%, #22c55e 100%);
        }

        .u-grid {
            display: grid;
            gap: 14px;
            grid-template-columns: repeat(12, 1fr)
        }

        @media (min-width:768px) {
            .u-grid>[class*=u-col-] {
                grid-column: auto/span 4
            }
        }

        .u-card {
            position: relative;
            border-radius: 16px;
            padding: 14px;
            background: var(--u-bg);
            border: 1px dashed var(--u-dash);
            transition: all .25s ease;
            box-shadow: 0 6px 24px rgba(0, 0, 0, .25);
        }

        .u-card:hover {
            border-color: #3aa9ff
        }

        .u-card.dragover {
            border-color: #30d17d;
            background: #0b1b27
        }

        .u-head {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 10px
        }

        .u-title {
            font-weight: 700;
            color: var(--u-fg)
        }

        .u-hint {
            font-size: .8rem;
            color: var(--u-sub)
        }

        .u-actions {
            display: flex;
            gap: 8px
        }

        .u-btn {
            border-radius: 999px;
            border: 1px solid #2b4a64;
            background: #0f2230;
            color: #cfe7ff;
            padding: 6px 12px;
            font-size: .85rem;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: .2s;
        }

        .u-btn:hover {
            transform: translateY(-1px);
            border-color: #3aa9ff
        }

        .u-btn.icon {
            width: 34px;
            height: 34px;
            justify-content: center;
            padding: 0
        }

        .u-btn.del {
            border-color: #7a2b2b;
            color: #ffbcbc;
            background: #1a0f12
        }

        .u-stage {
            background: var(--u-panel);
            border-radius: 14px;
            min-height: 170px;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden
        }

        .u-empty {
            color: #9cc0db;
            text-align: center;
            display: flex;
            flex-direction: column;
            gap: 8px
        }

        .u-empty i {
            font-size: 30px;
            opacity: .8
        }

        .u-preview {
            max-height: 160px;
            max-width: 100%;
            display: none;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, .35)
        }

        .u-badge {
            position: absolute;
            top: 10px;
            inset-inline-start: 10px;
            background: #0e2433;
            color: #bfe6ff;
            border: 1px solid #23465e;
            border-radius: 999px;
            padding: 4px 10px;
            font-size: .75rem
        }

        .u-check {
            position: absolute;
            top: 10px;
            inset-inline-end: 10px;
            background: #0e2433;
            border-radius: 999px;
            color: #7dffb6;
            border: 1px solid #225942;
            padding: 4px 8px;
            font-size: .8rem;
            display: none
        }

        .u-progress {
            height: 6px;
            background: #0c2332;
            border-radius: 999px;
            overflow: hidden;
            margin-top: 10px;
            display: none
        }

        .u-progress .bar {
            height: 100%;
            width: 0;
            background: var(--u-grad);
            transition: width .15s
        }

        .u-fileinfo {
            display: flex;
            justify-content: space-between;
            gap: 10px;
            color: #9ec2df;
            font-size: .82rem;
            margin-top: 8px
        }

        .u-skeleton {
            position: absolute;
            inset: 0;
            background: linear-gradient(90deg, rgba(255, 255, 255, .03) 0%, rgba(255, 255, 255, .08) 50%, rgba(255, 255, 255, .03) 100%);
            background-size: 200% 100%;
            animation: sk 1.2s linear infinite;
            display: none
        }

        @keyframes sk {
            to {
                background-position: -200% 0
            }
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($e); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e($action); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?> <?php if($isEdit): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>

            <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
                <h5 class="mb-0"><?php echo e($isEdit ? 'تعديل عضو' : 'إضافة عضو'); ?></h5>
                <div class="d-flex gap-2">
                    <button class="btn btn-primary"><i class="fas fa-save mx-2"></i><?php echo e($isEdit ? 'تحديث' : 'حفظ'); ?></button>
                    <a class="btn btn-secondary" href="<?php echo e(route('members.index')); ?>">رجوع</a>
                </div>
            </div>

            <div class="tabs-sticky mb-3">
                <ul class="nav nav-tabs" id="tabs" role="tablist">
                    <li class="nav-item"><button class="nav-link active text-light" data-bs-toggle="tab"
                            data-bs-target="#tab-basic" type="button">البيانات الأساسية</button></li>

                    <li class="nav-item"><button class="nav-link text-light" data-bs-toggle="tab"
                            data-bs-target="#tab-contact" type="button">التواصل والعنوان</button></li>

                    <li class="nav-item"><button class="nav-link text-light" data-bs-toggle="tab"
                            data-bs-target="#tab-extra" type="button">كيف تعرفت علينا</button></li>
                </ul>
            </div>

            <div class="tab-content">
                
                <div class="tab-pane fade show active" id="tab-basic">
                    <div class="card-section">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">الفرع <span class="text-danger">*</span></label>
                                <select name="branch_id" id="branch_id" class="form-select" <?php echo e($isEdit ? 'disabled' : ''); ?>

                                    required>
                                    <option value="">— اختر —</option>
                                    <?php $__currentLoopData = \App\Models\Branch::orderBy('id')->get(['id', 'name', 'branch_code']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($b->id); ?>" <?php if(old('branch_id', $isEdit ? $member->branch_id : null) == $b->id): echo 'selected'; endif; ?>>
                                            <?php echo e(method_exists($b, 'getTranslation') ? $b->getTranslation('name', app()->getLocale()) : (is_array($b->name) ? $b->name[app()->getLocale()] ?? ($b->name['en'] ?? '') : $b->name)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($isEdit): ?>
                                    <input type="hidden" name="branch_id" value="<?php echo e($member->branch_id); ?>">
                                <?php endif; ?>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">كود العضو</label>
                                <input type="text" id="code_preview" class="form-control"
                                    value="<?php echo e($isEdit ? $member->member_code : '— حدّد الفرع لعرض الكود —'); ?>" readonly>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">حالة العضو</label>
                                <?php $st = old('status',$isEdit ? $member->status : 'new'); ?>
                                <select name="status" class="form-select">
                                    <option value="new" <?php if($st === 'new'): echo 'selected'; endif; ?>>جديد</option>
                                    <option value="active" <?php if($st === 'active'): echo 'selected'; endif; ?>>نشط</option>
                                    <option value="inactive"<?php if($st === 'inactive'): echo 'selected'; endif; ?>>غير نشط</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">اسم العضو <span class="text-danger">*</span></label>
                                <input type="text" name="name" class="form-control"
                                    value="<?php echo e(old('name', $isEdit ? $member->name : '')); ?>" required>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">الجنس</label>
                                <?php $g = old('gender',$isEdit?$member->gender:null); ?>
                                <select name="gender" class="form-select">
                                    <option value="">—</option>
                                    <option value="male" <?php if($g === 'male'): echo 'selected'; endif; ?>>ذكر</option>
                                    <option value="female" <?php if($g === 'female'): echo 'selected'; endif; ?>>أنثى</option>
                                </select>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">الجنسية</label>
                                <select name="nationality_id" class="form-select">
                                    <option value="">—</option>
                                    <?php $__currentLoopData = \App\Models\Country::orderBy('name')->get(['id', 'name']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($c->id); ?>" <?php if(old('nationality_id', $isEdit ? $member->nationality_id : null) == $c->id): echo 'selected'; endif; ?>>
                                            <?php echo e(method_exists($c, 'getTranslation') ? $c->getTranslation('name', app()->getLocale()) : (is_array($c->name) ? $c->name[app()->getLocale()] ?? ($c->name['en'] ?? '') : $c->name)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">تاريخ الميلاد (ميلادي)</label>
                                <input type="date" id="birth_greg" name="birth_greg" class="form-control"
                                    value="<?php echo e(old('birth_greg', $isEdit ? optional($member->birth_greg)->format('Y-m-d') : '')); ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">تاريخ الميلاد (هجري)</label>
                                <input type="text" id="birth_hijri" name="birth_hijri" class="form-control"
                                    value="<?php echo e(old('birth_hijri', $isEdit ? $member->birth_hijri : '')); ?>" readonly>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">العمر</label>
                                <input type="text" id="age" class="form-control"
                                    value="<?php echo e(old('age', $isEdit ? $member->age : '')); ?>" readonly>
                            </div>
                        </div>
                    </div>

                    <div class="card-section">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">نوع البطاقة</label>
                                <?php $t=old('id_type',$isEdit?$member->id_type:null); ?>
                                <select name="id_type" id="id_type" class="form-select">
                                    <option value="">—</option>
                                    <option value="national_id" <?php if($t === 'national_id'): echo 'selected'; endif; ?>>بطاقة شخصية</option>
                                    <option value="iqama" <?php if($t === 'iqama'): echo 'selected'; endif; ?>>إقامة</option>
                                    <option value="passport" <?php if($t === 'passport'): echo 'selected'; endif; ?>>جواز سفر</option>
                                    <option value="driving_license"<?php if($t === 'driving_license'): echo 'selected'; endif; ?>>رخصة قيادة</option>
                                    <option value="work_card" <?php if($t === 'work_card'): echo 'selected'; endif; ?>>بطاقة عمل</option>
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">رقم الهوية</label>
                                <input type="text" name="id_number" id="id_number" class="form-control"
                                    placeholder="10 أرقام للسعودية/الإقامة"
                                    value="<?php echo e(old('id_number', $isEdit ? $member->id_number : '')); ?>">
                                <div class="form-text">بطاقة شخصية يجب أن تبدأ بـ 1 – الإقامة بـ 2 (10 أرقام).</div>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">تاريخ الإصدار (ميلادي)</label>
                                <input type="date" name="id_issue_greg" id="id_issue_greg" class="form-control"
                                    value="<?php echo e(old('id_issue_greg', $isEdit ? optional($member->id_issue_greg)->format('Y-m-d') : '')); ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">تاريخ الإصدار (هجري)</label>
                                <input type="text" name="id_issue_hijri" id="id_issue_hijri" class="form-control"
                                    value="<?php echo e(old('id_issue_hijri', $isEdit ? $member->id_issue_hijri : '')); ?>" readonly>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">تاريخ الانتهاء (ميلادي)</label>
                                <input type="date" name="id_expiry_greg" id="id_expiry_greg" class="form-control"
                                    value="<?php echo e(old('id_expiry_greg', $isEdit ? optional($member->id_expiry_greg)->format('Y-m-d') : '')); ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">تاريخ الانتهاء (هجري)</label>
                                <input type="text" name="id_expiry_hijri" id="id_expiry_hijri" class="form-control"
                                    value="<?php echo e(old('id_expiry_hijri', $isEdit ? $member->id_expiry_hijri : '')); ?>"
                                    readonly>
                            </div>
                        </div>
                    </div>

                    <div class="card-section">
                        <h6 class="mb-2">الصور</h6>
                        <div class="u-grid">
                            
                            <?php $avatarUrl = isset($member) && $member->avatar_path ? asset($member->avatar_path) : ''; ?>
                            <div class="u-col-4">
                                <div class="u-card" id="u_avatar">
                                    <div class="u-head">
                                        <div>
                                            <div class="u-title">الصورة الشخصية</div>


                                        </div>
                                        <div class="u-actions">
                                            <button type="button" class="u-btn" id="pick_avatar"><i
                                                    class="fas fa-upload"></i>اختر</button>
                                            <button type="button" class="u-btn icon del d-none" id="del_avatar"
                                                title="حذف"><i class="fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                    <div class="u-stage">

                                        <div class="u-check" id="ok_avatar"><i class="fas fa-check"></i></div>
                                        <div class="u-skeleton" id="sk_avatar"></div>
                                        <img class="u-preview" id="prev_avatar" src="<?php echo e($avatarUrl); ?>"
                                            style="display:<?php echo e($avatarUrl ? 'block' : 'none'); ?>">
                                        <div class="u-empty" id="empty_avatar"
                                            style="display:<?php echo e($avatarUrl ? 'none' : 'flex'); ?>">
                                            <i class="fas fa-user-circle"></i>
                                            <div>لا توجد صورة</div>
                                        </div>
                                        <input type="file" class="d-none" id="file_avatar" accept="image/*">
                                    </div>
                                    <div class="u-progress" id="progwrap_avatar">
                                        <div class="bar" id="prog_avatar"></div>
                                    </div>
                                    <div class="u-fileinfo"><span id="name_avatar">—</span><span id="size_avatar"></span>
                                    </div>
                                    <input type="hidden" name="avatar_uploaded_path" id="path_avatar"
                                        value="<?php echo e($member->avatar_path ?? ''); ?>">
                                </div>
                            </div>

                            
                            <?php $idUrl = isset($member) && $member->id_image_path ? asset($member->id_image_path) : ''; ?>
                            <div class="u-col-4">
                                <div class="u-card" id="u_id">
                                    <div class="u-head">
                                        <div>
                                            <div class="u-title">صورة الهوية</div>
                                            <div class="u-hint">PNG/JPG حتى 3MB</div>
                                        </div>
                                        <div class="u-actions">
                                            <button type="button" class="u-btn" id="pick_id"><i
                                                    class="fas fa-upload"></i>اختر</button>
                                            <button type="button" class="u-btn icon del d-none" id="del_id"
                                                title="حذف"><i class="fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                    <div class="u-stage">

                                        <div class="u-check" id="ok_id"><i class="fas fa-check"></i></div>
                                        <div class="u-skeleton" id="sk_id"></div>
                                        <img class="u-preview" id="prev_id" src="<?php echo e($idUrl); ?>"
                                            style="display:<?php echo e($idUrl ? 'block' : 'none'); ?>">
                                        <div class="u-empty" id="empty_id"
                                            style="display:<?php echo e($idUrl ? 'none' : 'flex'); ?>">
                                            <i class="fas fa-id-card"></i>
                                            <div>لا توجد صورة</div>
                                        </div>
                                        <input type="file" class="d-none" id="file_id" accept="image/*">
                                    </div>
                                    <div class="u-progress" id="progwrap_id">
                                        <div class="bar" id="prog_id"></div>
                                    </div>
                                    <div class="u-fileinfo"><span id="name_id">—</span><span id="size_id"></span>
                                    </div>
                                    <input type="hidden" name="id_image_uploaded_path" id="path_id"
                                        value="<?php echo e($member->id_image_path ?? ''); ?>">
                                </div>
                            </div>

                            
                            <?php $workUrl = isset($member) && $member->work_card_image_path ? asset($member->work_card_image_path) : ''; ?>
                            <div class="u-col-4">
                                <div class="u-card" id="u_work">
                                    <div class="u-head">
                                        <div>
                                            <div class="u-title">صورة بطاقة العمل</div>
                                            <div class="u-hint">PNG/JPG حتى 3MB</div>
                                        </div>
                                        <div class="u-actions">
                                            <button type="button" class="u-btn" id="pick_work"><i
                                                    class="fas fa-upload"></i>اختر</button>
                                            <button type="button" class="u-btn icon del d-none" id="del_work"
                                                title="حذف"><i class="fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                    <div class="u-stage">

                                        <div class="u-check" id="ok_work"><i class="fas fa-check"></i></div>
                                        <div class="u-skeleton" id="sk_work"></div>
                                        <img class="u-preview" id="prev_work" src="<?php echo e($workUrl); ?>"
                                            style="display:<?php echo e($workUrl ? 'block' : 'none'); ?>">
                                        <div class="u-empty" id="empty_work"
                                            style="display:<?php echo e($workUrl ? 'none' : 'flex'); ?>">
                                            <i class="fas fa-briefcase"></i>
                                            <div>لا توجد صورة</div>
                                        </div>
                                        <input type="file" class="d-none" id="file_work" accept="image/*">
                                    </div>
                                    <div class="u-progress" id="progwrap_work">
                                        <div class="bar" id="prog_work"></div>
                                    </div>
                                    <div class="u-fileinfo"><span id="name_work">—</span><span id="size_work"></span>
                                    </div>
                                    <input type="hidden" name="work_card_image_uploaded_path" id="path_work"
                                        value="<?php echo e($member->work_card_image_path ?? ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>




                
                <div class="tab-pane fade" id="tab-contact">
                    <div class="card-section">
                        <div class="row g-3">
                            <div class="col-md-4"><label class="form-label">الهاتف</label><input type="text"
                                    name="phone" class="form-control"
                                    value="<?php echo e(old('phone', $isEdit ? $member->phone : '')); ?>"></div>
                            <div class="col-md-4"><label class="form-label">البريد الإلكتروني</label><input
                                    type="email" name="email" class="form-control"
                                    value="<?php echo e(old('email', $isEdit ? $member->email : '')); ?>"></div>
                            <div class="col-md-4"><label class="form-label">صندوق البريد</label><input type="text"
                                    name="po_box" class="form-control"
                                    value="<?php echo e(old('po_box', $isEdit ? $member->po_box : '')); ?>"></div>
                            <div class="col-md-4"><label class="form-label">الرمز البريدي</label><input type="text"
                                    name="postal_code" class="form-control"
                                    value="<?php echo e(old('postal_code', $isEdit ? $member->postal_code : '')); ?>"></div>
                            <div class="col-md-8"><label class="form-label">العنوان</label><input type="text"
                                    name="address" class="form-control"
                                    value="<?php echo e(old('address', $isEdit ? $member->address : '')); ?>"></div>
                        </div>
                    </div>
                </div>



                
                <div class="tab-pane fade" id="tab-extra">
                    <div class="card-section">
                        <?php
                            $options = [
                                'friend' => 'صديق',
                                'instagram' => 'إنستغرام',
                                'twitter' => 'تويتر',
                                'facebook' => 'فيسبوك',
                                'flyer' => 'منشور/ملصق',
                                'other' => 'أخرى',
                            ];
                            $selected = old('how_heard', $isEdit ? $member->how_heard ?? [] : []);
                        ?>
                        <p class="mb-2">كيف تعرفت علينا؟ (اختياري — لا شيء مُحدد افتراضيًا)</p>
                        <div class="d-flex flex-wrap gap-3">
                            <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $lbl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="how_heard[]"
                                        id="hh_<?php echo e($k); ?>" value="<?php echo e($k); ?>"
                                        <?php if(in_array($k, $selected)): echo 'checked'; endif; ?>>
                                    <label class="form-check-label"
                                        for="hh_<?php echo e($k); ?>"><?php echo e($lbl); ?></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>

        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/min/moment.min.js"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/moment-hijri@2.1.2/moment-hijri.min.js"></script>

    <script>
        // ===== فحص أن الإضافة اتحملت =====
        (function ensureHijriLoaded() {
            if (typeof moment === 'undefined') {
                console.error('moment لم يُحمّل');
                return;
            }
            if (typeof moment().iYear !== 'function') {
                console.error('moment-hijri لم يُحمّل — تأكد من رابط السكربت أو كاش المتصفح');
            }
        })();

        // ===== تحويلات التاريخ =====
        function gToH(g) {
            if (!g) return '';
            // لو الإضافة مش متاحة، رجّع نص فاضي
            if (typeof moment().iYear !== 'function') return '';
            const m = moment(g, 'YYYY-MM-DD', true);
            return m.isValid() ? m.format('iYYYY-iMM-iDD') : '';
        }

        function hToG(h) {
            if (!h) return '';
            if (typeof moment().iYear !== 'function') return '';
            const m = moment(h, 'iYYYY-iMM-iDD', true);
            return m.isValid() ? m.format('YYYY-MM-DD') : '';
        }

        // ربط الحقول (عدّل الـ IDs لو مختلفة)
        const pairs = [
            ['birth_greg', 'birth_hijri'], // ميلاد
            ['id_issue_greg', 'id_issue_hijri'], // إصدار هوية
            ['id_expiry_greg', 'id_expiry_hijri'] // انتهاء هوية
        ];

        document.addEventListener('DOMContentLoaded', function() {
            // توقع كود العضو (لو عندك نفس المنطق)
            const branchSel = document.getElementById('branch_id');
            const codePrev = document.getElementById('code_preview');

            function loadCode() {
                if (!branchSel?.value) {
                    codePrev && (codePrev.value = '— حدّد الفرع —');
                    return;
                }
                fetch(`<?php echo e(route('members.predict')); ?>?branch_id=${branchSel.value}`)
                    .then(r => r.json()).then(j => codePrev && (codePrev.value = j.code || '—'))
                    .catch(() => codePrev && (codePrev.value = '—'));
            }
            branchSel && branchSel.addEventListener('change', loadCode);
            <?php if(!isset($isEdit) || !$isEdit): ?>
                branchSel && branchSel.value && loadCode();
            <?php endif; ?>

            // ربط الميلادي/الهجري + حساب العمر
            const ageInp = document.getElementById('age');

            pairs.forEach(([gId, hId]) => {
                const g = document.getElementById(gId);
                const h = document.getElementById(hId);
                if (!g || !h) return;

                const syncFromG = () => {
                    h.value = gToH(g.value);
                    if (gId === 'birth_greg' && ageInp) {
                        if (g.value) {
                            const years = moment().diff(moment(g.value, 'YYYY-MM-DD'), 'years');
                            ageInp.value = isFinite(years) ? years : '';
                        } else {
                            ageInp.value = '';
                        }
                    }
                };
                const syncFromH = () => {
                    g.value = hToG(h.value);
                    if (gId === 'birth_greg' && ageInp) {
                        if (g.value) {
                            const years = moment().diff(moment(g.value, 'YYYY-MM-DD'), 'years');
                            ageInp.value = isFinite(years) ? years : '';
                        } else {
                            ageInp.value = '';
                        }
                    }
                };

                g.addEventListener('change', syncFromG);
                h.addEventListener('change', syncFromH);

                // تهيئة أولية
                if (g.value && !h.value) syncFromG();
                if (h.value && !g.value) syncFromH();
            });

            // تلميح نوع الهوية
            const idType = document.getElementById('id_type');
            const idNum = document.getElementById('id_number');

            function maskId() {
                if (!idType || !idNum) return;
                idNum.placeholder =
                    idType.value === 'national_id' ? '10 أرقام تبدأ بـ 1' :
                    idType.value === 'iqama' ? '10 أرقام تبدأ بـ 2' : '';
            }
            idType && idType.addEventListener('change', maskId);
            maskId();
        });
    </script>


    <script>
        (function() {
            const csrf = document.querySelector('meta[name="csrf-token"]')?.content || '';

            // فورماتر حجم الملف
            const fmt = b => {
                if (!b && b !== 0) return '';
                const u = ['B', 'KB', 'MB', 'GB'];
                let i = 0;
                while (b >= 1024 && i < u.length - 1) {
                    b /= 1024;
                    i++
                }
                return `${b.toFixed( i?1:0)} ${u[i]}`;
            };

            // objectURL management
            const map = new Map();
            const setPrev = (img, fileOrUrl) => {
                if (!img) return;
                const k = img.id;
                if (map.has(k)) {
                    URL.revokeObjectURL(map.get(k));
                    map.delete(k);
                }
                if (fileOrUrl instanceof File) {
                    const u = URL.createObjectURL(fileOrUrl);
                    map.set(k, u);
                    img.src = u;
                    img.style.display = 'block';
                } else if (fileOrUrl) {
                    img.src = fileOrUrl;
                    img.style.display = 'block';
                } else {
                    img.removeAttribute('src');
                    img.style.display = 'none';
                }
            };

            function card(cfg) {
                const wrap = document.getElementById(cfg.wrap);
                const pick = document.getElementById(cfg.pick);
                const file = document.getElementById(cfg.file);
                const prev = document.getElementById(cfg.prev);
                const empty = document.getElementById(cfg.empty);
                const del = document.getElementById(cfg.del);
                const pWrap = document.getElementById(cfg.pWrap);
                const pBar = document.getElementById(cfg.pBar);
                const ok = document.getElementById(cfg.ok);
                const name = document.getElementById(cfg.name);
                const size = document.getElementById(cfg.size);
                const path = document.getElementById(cfg.path);
                const skel = document.getElementById(cfg.skel);

                // حالة أولية
                if (path.value) {
                    del.classList.remove('d-none');
                }
                if (prev.getAttribute('src')) empty.style.display = 'none';

                // زر اختيار
                pick.addEventListener('click', () => file.click());
                // حذف
                del.addEventListener('click', () => {
                    const p = path.value;
                    path.value = '';
                    name.textContent = '—';
                    size.textContent = '';
                    setPrev(prev, '');
                    empty.style.display = 'flex';
                    del.classList.add('d-none');
                    ok.style.display = 'none';
                    if (!p) return;
                    fetch("<?php echo e(route('members.upload.delete')); ?>", {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': csrf,
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            path: p
                        })
                    });
                });

                // سحب-إفلات
                ['dragenter', 'dragover'].forEach(eName => {
                    wrap.addEventListener(eName, e => {
                        e.preventDefault();
                        wrap.classList.add('dragover')
                    });
                });
                ['dragleave', 'drop'].forEach(eName => {
                    wrap.addEventListener(eName, e => {
                        e.preventDefault();
                        wrap.classList.remove('dragover')
                    });
                });
                wrap.addEventListener('drop', e => {
                    const f = e.dataTransfer.files?.[0];
                    if (f) doUpload(f);
                });

                // تغيير الملف
                file.addEventListener('change', () => {
                    const f = file.files?.[0];
                    if (!f) return;
                    doUpload(f);
                });

                function doUpload(f) {
                    if (!f.type.match(/^image\//)) {
                        alert('يُسمح برفع الصور فقط');
                        return;
                    }
                    // UI
                    setPrev(prev, f);
                    empty.style.display = 'none';
                    del.classList.remove('d-none');
                    ok.style.display = 'none';
                    pBar.style.width = '0%';
                    pWrap.style.display = 'block';
                    skel.style.display = 'block';

                    const fd = new FormData();
                    fd.append('file', f);
                    fd.append('field', cfg.field);

                    const xhr = new XMLHttpRequest();
                    xhr.open('POST', "<?php echo e(route('members.upload')); ?>", true);
                    xhr.setRequestHeader('X-CSRF-TOKEN', csrf);

                    xhr.upload.onprogress = e => {
                        if (e.lengthComputable) {
                            const pct = Math.round(e.loaded / e.total * 100);
                            pBar.style.width = pct + '%';
                        }
                    };
                    xhr.onreadystatechange = () => {
                        if (xhr.readyState === 4) {
                            skel.style.display = 'none';
                            setTimeout(() => pWrap.style.display = 'none', 300);
                            if (xhr.status >= 200 && xhr.status < 300) {
                                let res = {};
                                try {
                                    res = JSON.parse(xhr.responseText)
                                } catch {}
                                if (res.ok) {
                                    path.value = res.path || '';
                                    if (res.url) setPrev(prev, res.url);
                                    ok.style.display = 'inline-flex';
                                    name.textContent = f.name;
                                    size.textContent = fmt(f.size);
                                } else {
                                    alert('فشل رفع الملف');
                                    reset();
                                }
                            } else {
                                alert('تعذر رفع الملف');
                                reset();
                            }
                        }
                    };
                    xhr.send(fd);

                    function reset() {
                        path.value = '';
                        name.textContent = '—';
                        size.textContent = '';
                        setPrev(prev, '');
                        empty.style.display = 'flex';
                        del.classList.add('d-none');
                        ok.style.display = 'none';
                    }
                }
            }

            // تفعيل البطاقات الثلاث
            card({
                wrap: 'u_avatar',
                pick: 'pick_avatar',
                file: 'file_avatar',
                prev: 'prev_avatar',
                empty: 'empty_avatar',
                del: 'del_avatar',
                pWrap: 'progwrap_avatar',
                pBar: 'prog_avatar',
                ok: 'ok_avatar',
                name: 'name_avatar',
                size: 'size_avatar',
                path: 'path_avatar',
                skel: 'sk_avatar',
                field: 'avatar'
            });
            card({
                wrap: 'u_id',
                pick: 'pick_id',
                file: 'file_id',
                prev: 'prev_id',
                empty: 'empty_id',
                del: 'del_id',
                pWrap: 'progwrap_id',
                pBar: 'prog_id',
                ok: 'ok_id',
                name: 'name_id',
                size: 'size_id',
                path: 'path_id',
                skel: 'sk_id',
                field: 'id_image'
            });
            card({
                wrap: 'u_work',
                pick: 'pick_work',
                file: 'file_work',
                prev: 'prev_work',
                empty: 'empty_work',
                del: 'del_work',
                pWrap: 'progwrap_work',
                pBar: 'prog_work',
                ok: 'ok_work',
                name: 'name_work',
                size: 'size_work',
                path: 'path_work',
                skel: 'sk_work',
                field: 'work_card_image'
            });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\Pioneer\resources\views/admin/members/form.blade.php ENDPATH**/ ?>