<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">

<head>
    <meta charset="UTF-8">
    <title><?php echo e(__('member.login')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    <!-- jQuery Validation -->
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.min.js"></script>

    <style>
        body.light {
            background: linear-gradient(180deg, #f8fafc, #eef2f7);
            color: #000;
        }

        body.dark {
            background: #0f172a;
            color: #fff;
        }

        .auth-card {
            border-radius: 18px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, .15);
            overflow: hidden;
        }

        .auth-image {
            background:
                linear-gradient(rgba(0, 0, 0, .6), rgba(0, 0, 0, .6)),
                url('/front_assets/imge/login-banner.jpg') center/cover no-repeat;
        }

        .auth-form {
            padding: 16px;
        }

        @media (min-width: 768px) {
            .auth-form {
                padding: 40px;
            }
        }

        .form-control {
            border-radius: 12px;
            padding: 12px 14px;
        }

        .error {
            color: #dc3545;
            font-size: 13px;
            margin-top: 4px;
        }

        .global-error {
            display: none;
            background: #dc3545;
            color: #fff;
            padding: 10px;
            border-radius: 10px;
            margin-bottom: 15px;
            font-size: 14px;
        }
    </style>
</head>

<body class="light">

    <div class="container">
        <div class="row min-vh-100 justify-content-center align-items-center">

            <div class="col-12 col-sm-10 col-md-8 col-lg-7 col-xl-6">
                <div class="card auth-card">

                    <div class="row g-0">

                        <div class="col-md-5 d-none d-md-flex auth-image align-items-center text-white">
                            <div class="p-4">
                                <h4 class="fw-bold"><?php echo e(__('member.welcome_back')); ?></h4>
                                <p class="text-white-50"><?php echo e(__('member.login_desc')); ?></p>
                            </div>
                        </div>

                        <div class="col-md-7 auth-form">

                            <div class="text-center mb-4">
                                <img src="<?php echo e(asset('front_assets/imge/logo 1.png')); ?>" height="50" class="mb-2">
                                <h5 class="fw-bold"><?php echo e(__('member.login')); ?></h5>
                            </div>

                            <div class="global-error" id="loginError">
                                <?php echo e(__('member.invalid_credentials')); ?>

                            </div>

                            <form id="loginForm" method="POST" action="<?php echo e(route('member.login')); ?>">
                                <?php echo csrf_field(); ?>

                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('member.email')); ?></label>
                                    <input type="email" name="email" class="form-control">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('member.password')); ?></label>
                                    <input type="password" name="password" class="form-control">
                                </div>

                                <button class="btn btn-primary w-100 mt-2">
                                    <?php echo e(__('member.login')); ?>

                                </button>
                            </form>

                            <div class="text-center mt-3">
                                <?php echo e(__('member.no_account')); ?>

                                <a href="<?php echo e(route('member.register.form')); ?>" class="fw-bold">
                                    <?php echo e(__('member.register')); ?>

                                </a>
                            </div>

                        </div>

                    </div>

                </div>
            </div>

        </div>
    </div>

    <script>
        $('#loginForm').validate({
            rules: {
                email: {
                    required: true,
                    email: true
                },
                password: {
                    required: true
                }
            },
            invalidHandler: function() {
                $('#loginError').fadeIn();
            }
        });
    </script>
    

</body>

</html>
<?php /**PATH E:\xampp\htdocs\shapooov\resources\views/auth/member/login.blade.php ENDPATH**/ ?>