<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">

<head>
    <meta charset="UTF-8">
    <title><?php echo e(__('member.register')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    <!-- jQuery Validation -->
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.min.js"></script>

    <style>
        /* =====================
           Base
        ====================== */
        body {
            transition: background 0.3s, color 0.3s;
        }

        body.light {
            background: linear-gradient(180deg, #f8fafc, #eef2f7);
            color: #000;
        }

        body.dark {
            background: #0f172a;
            color: #fff;
        }

        /* =====================
           Top Actions
        ====================== */
        .top-bar {
            position: fixed;
            top: 20px;
            width: 100%;
            z-index: 999;
        }

        .top-actions {
            position: absolute;
            display: flex;
            gap: 10px;
        }

        .top-actions.right-pos {
            right: 20px;
        }

        .top-actions.left-pos {
            left: 20px;
        }

        .action-btn {
            display: flex;
            align-items: center;
            gap: 6px;
            padding: 6px 14px;
            background: rgba(255, 255, 255, .95);
            border-radius: 30px;
            border: 1px solid #ddd;
            font-size: 14px;
            color: #333;
            transition: .25s;
        }

        body.dark .action-btn {
            background: rgba(15, 23, 42, .95);
            color: #fff;
            border-color: #334155;
        }

        .action-btn:hover {
            background: #0d6efd;
            color: #fff;
            border-color: #0d6efd;
        }

        /* =====================
           Card
        ====================== */
        .auth-card {
            border-radius: 18px;
            overflow: hidden;
            box-shadow: 0 20px 60px rgba(0, 0, 0, .15);
        }

        .auth-image {
            background:
                linear-gradient(rgba(0, 0, 0, .3), rgba(0, 0, 0, .3)),
                url(<?php echo e(asset('bannar.jpeg')); ?>) center/cover no-repeat;
        }

        .auth-image .overlay {
            padding: 50px;
        }

        /* =====================
           Form
        ====================== */
        .auth-form {
            padding: 16px;
        }

        @media (min-width: 576px) {
            .auth-form {
                padding: 24px;
            }
        }

        @media (min-width: 768px) {
            .auth-form {
                padding: 40px;
            }
        }

        @media (min-width: 1200px) {
            .auth-form {
                padding: 60px;
            }
        }

        .form-control {
            border-radius: 12px;
            padding: 12px 14px;
        }

        .form-control:focus {
            border-color: #0d6efd;
            box-shadow: 0 0 0 .15rem rgba(13, 110, 253, .25);
        }

        /* =====================
           Validation
        ====================== */
        .error {
            color: #dc3545;
            font-size: 13px;
            margin-top: 4px;
        }

        input.error {
            border-color: #dc3545;
        }

        .global-error {
            display: none;
            background: #dc3545;
            color: #fff;
            padding: 10px;
            border-radius: 10px;
            margin-bottom: 15px;
            font-size: 14px;
        }

        /* =====================
           Mobile tweaks
        ====================== */
        @media (max-width: 576px) {
            h4 {
                font-size: 18px;
            }

            .btn {
                padding: 14px;
                font-size: 16px;
            }
        }
    </style>
</head>

<body class="light">

    <!-- Top Actions -->
    <div class="top-bar">
        <div class="top-actions <?php echo e(app()->getLocale() == 'ar' ? 'left-pos' : 'right-pos'); ?>">
            <a href="<?php echo e(LaravelLocalization::getLocalizedURL(app()->getLocale() == 'ar' ? 'en' : 'ar')); ?>"
                class="action-btn">
                <i class="bi bi-translate"></i>
                <?php echo e(app()->getLocale() == 'ar' ? 'EN' : 'عربي'); ?>

            </a>

            <button id="themeToggle" class="action-btn">
                <i class="bi bi-moon-stars-fill"></i>
            </button>
        </div>
    </div>

    <div class="container">
        <div class="row min-vh-100 justify-content-center align-items-start align-items-md-center pt-5 pt-md-0">

            <div class="col-12 col-sm-11 col-md-10 col-lg-9 col-xl-10">
                <div class="card auth-card">

                    <div class="row g-0">

                        <!-- Image -->
                        <div class="col-xl-5 d-none d-xl-flex auth-image text-white align-items-center">
                            <div class="overlay">
                                <h2 class="fw-bold mb-3"><?php echo e(__('member.join_us')); ?></h2>
                                <p class="text-white-50"><?php echo e(__('member.register_desc')); ?></p>
                            </div>
                        </div>

                        <!-- Form -->
                        <div class="col-xl-7 auth-form">

                            <div class="text-center mb-4">
                                <img src="<?php echo e(asset('front_assets/imge/logo 1.png')); ?>" height="56" class="mb-3">
                                <h4 class="fw-bold"><?php echo e(__('member.register')); ?></h4>
                            </div>

                            <!-- Global Error -->
                            <div class="global-error" id="formError">
                                <?php echo e(__('member.fix_errors')); ?>

                            </div>

                            <form id="registerForm" method="POST" action="<?php echo e(route('member.register')); ?>">
                                <?php echo csrf_field(); ?>

                                <div class="row">
                                    <div class="col-12 col-md-6 mb-3">
                                        <label class="form-label"><?php echo e(__('member.name')); ?></label>
                                        <input type="text" name="name" class="form-control">
                                    </div>

                                    <div class="col-12 col-md-6 mb-3">
                                        <label class="form-label"><?php echo e(__('member.phone')); ?></label>
                                        <input type="text" name="phone" class="form-control">
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('member.email')); ?></label>
                                        <input type="email" name="email"
                                            class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('email')); ?>">

                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback d-block">
                                                <?php echo e($message); ?>

                                            </div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 col-md-6 mb-3">
                                        <label class="form-label"><?php echo e(__('member.password')); ?></label>
                                        <input type="password" name="password" class="form-control">
                                    </div>

                                    <div class="col-12 col-md-6 mb-3">
                                        <label class="form-label"><?php echo e(__('member.password_confirm')); ?></label>
                                        <input type="password" name="password_confirmation" class="form-control">
                                    </div>
                                </div>

                                <button type="submit" class="btn btn-primary w-100 mt-2">
                                    <i class="bi bi-person-plus"></i>
                                    <?php echo e(__('member.create_account')); ?>

                                </button>
                            </form>

                            <div class="text-center mt-4">
                                <?php echo e(__('member.have_account')); ?>

                                <a href="<?php echo e(route('member.login.form')); ?>" class="fw-bold">
                                    <?php echo e(__('member.login')); ?>

                                </a>
                            </div>

                        </div>

                    </div>

                </div>
            </div>

        </div>
    </div>

    <!-- Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Theme -->
    <script>
        document.getElementById('themeToggle').onclick = () => {
            document.body.classList.toggle('dark');
            document.body.classList.toggle('light');
        };
    </script>

    <!-- Validation -->
    <script>
        $('#registerForm').validate({
            errorClass: 'error',
            errorElement: 'div',

            rules: {
                name: {
                    required: true
                },
                phone: {
                    required: true
                },
                email: {
                    required: true,
                    email: true
                },
                password: {
                    required: true,
                    minlength: 6
                },
                password_confirmation: {
                    equalTo: "[name='password']"
                }
            },

            submitHandler: function(form) {
                form.submit();
            },

            invalidHandler: function() {
                $('#formError').fadeIn();
            }
        });
    </script>

    <script>
        $('input[name="email"]').on('blur', function() {
            const email = $(this).val();
            if (!email) return;

            $.post('<?php echo e(route('member.check.email')); ?>', {
                email: email,
                _token: '<?php echo e(csrf_token()); ?>'
            }, function(res) {
                if (res.exists) {
                    $('#formError')
                        .text('<?php echo e(__('member.email_exists')); ?>')
                        .fadeIn();
                }
            });
        });
    </script>


</body>

</html>
<?php /**PATH E:\xampp\htdocs\shapooov\resources\views/auth/member/register.blade.php ENDPATH**/ ?>