
<?php if(auth()->guard('web')->check()): ?>
    <aside class="page-sidebar bg-dark text-white shadow-lg position-fixed h-100" id="sidebar">

        <nav class="sidebar-menu mt-3">
            <ul class="list-unstyled px-2">

                <!-- Dashboard -->
                <li class="mb-2">
                    <a href="<?php echo e(route('admin.dashboard')); ?>"
                        class="d-flex align-items-center gap-3 text-white text-decoration-none py-2 px-3 rounded hover-item">
                        <i class="fa-solid fa-gauge-high fa-lg text-info"></i>
                        <span><?php echo e(__('sidebar.dashboard')); ?></span>
                    </a>
                </li>
                <li class="mb-2">
                    <a href="<?php echo e(route('settings.company.edit')); ?>"
                        class="d-flex align-items-center gap-3 text-white text-decoration-none py-2 px-3 rounded hover-item">
                        <i class="fa-solid fa-cog fa-lg text-info"></i>
                        <span><?php echo e(__('dashboard.setting')); ?></span>
                    </a>
                </li>
                <hr class="border-secondary my-2">

                <!-- Branches -->
                <li class="menu-group">
                    <button
                        class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                        <i class="fa-solid fa-building fa-lg text-success"></i>
                        <span><?php echo e(__('sidebar.branches')); ?></span>
                        <i class="fa-solid fa-angle-down me-auto"></i>
                    </button>

                    <ul class="submenu list-unstyled ms-4 mt-1">
                        <li><a href="<?php echo e(route('branch-categories.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.branch_categories')); ?></a></li>
                        <li><a href="<?php echo e(route('branch-types.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.branch_types')); ?></a></li>
                        <li><a href="<?php echo e(route('branches.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.branches_list')); ?></a></li>
                    </ul>
                </li>

                <!-- Services -->
                <li class="menu-group">
                    <button
                        class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                        <i class="fa-solid fa-dumbbell fa-lg text-primary"></i>
                        <span><?php echo e(__('sidebar.services')); ?></span>
                        <i class="fa-solid fa-angle-down me-auto"></i>
                    </button>

                    <ul class="submenu list-unstyled ms-4 mt-1">
                        <li><a href="<?php echo e(route('service-types.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.service_types')); ?></a></li>
                        <li><a href="<?php echo e(route('service-categories.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.service_categories')); ?></a></li>
                        <li><a href="<?php echo e(route('services.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.services_list')); ?></a></li>
                    </ul>
                </li>

                <!-- Customers -->
                <li class="menu-group">
                    <button
                        class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                        <i class="fa-solid fa-user-group fa-lg text-info"></i>
                        <span><?php echo e(__('sidebar.customers')); ?></span>
                        <i class="fas fa-angle-down me-auto"></i>
                    </button>

                    <ul class="submenu list-unstyled ms-4 mt-1">
                        <li><a href="<?php echo e(route('customers.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.customers_list')); ?></a></li>
                        <li><a href="<?php echo e(route('customers.create')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.customer_create')); ?></a></li>
                    </ul>
                </li>

                <!-- Members -->
                <li class="menu-group">
                    <button
                        class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                        <i class="fas fa-users fa-lg text-success"></i>
                        <span><?php echo e(__('sidebar.members')); ?></span>
                        <i class="fas fa-angle-down me-auto"></i>
                    </button>

                    <ul class="submenu list-unstyled ms-4 mt-1">
                        <li><a href="<?php echo e(route('members.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.members_list')); ?></a></li>
                        <li><a href="<?php echo e(route('members.create')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.member_create')); ?></a></li>
                    </ul>
                </li>

                <!-- Offers -->
                <li class="menu-group">
                    <button
                        class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                        <i class="fa-solid fa-tags fa-lg text-danger"></i>
                        <span><?php echo e(__('sidebar.offers')); ?></span>
                        <i class="fa-solid fa-angle-down me-auto"></i>
                    </button>

                    <ul class="submenu list-unstyled ms-4 mt-1">
                        <li><a href="<?php echo e(route('offers.index')); ?>" class="submenu-item"><?php echo e(__('sidebar.offers_list')); ?></a>
                        </li>
                        <li><a href="<?php echo e(route('offers.create')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.offer_create')); ?></a></li>
                    </ul>
                </li>

                <!-- Subscription -->
                <li class="menu-group">
                    <button
                        class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                        <i class="fa-solid fa-lg fa-shopping-cart text-danger"></i>
                        <span><?php echo e(__('sidebar.subscriptions')); ?></span>
                        <i class="fa-solid fa-angle-down me-auto"></i>
                    </button>

                    <ul class="submenu list-unstyled ms-4 mt-1">
                        <li><a href="<?php echo e(route('subscriptions.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.subscriptions_list')); ?></a></li>
                        <li><a href="<?php echo e(route('subscriptions.create')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.subscription_create')); ?></a></li>
                    </ul>
                </li>

                <!-- Service Invoices -->
                <li class="menu-group">
                    <button
                        class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                        <i class="fa-solid fa-lg fa-file-invoice-dollar text-warning"></i>
                        <span><?php echo e(__('sidebar.service_invoices')); ?></span>
                        <i class="fa-solid fa-angle-down me-auto"></i>
                    </button>

                    <ul class="submenu list-unstyled ms-4 mt-1">
                        <li><a href="<?php echo e(route('service-invoices.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.service_invoices_list')); ?></a></li>
                        <li><a href="<?php echo e(route('service-invoices.create')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.service_invoices_create')); ?></a></li>
                    </ul>
                </li>

                <!-- Payment Methods -->
                <li class="menu-group">
                    <button
                        class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                        <i class="fa-solid fa-credit-card fa-lg text-info"></i>
                        <span><?php echo e(__('sidebar.payment_methods')); ?></span>
                        <i class="fa-solid fa-angle-down me-auto"></i>
                    </button>

                    <ul class="submenu list-unstyled ms-4 mt-1">
                        <li><a href="<?php echo e(route('payment-methods.index')); ?>"
                                class="submenu-item"><?php echo e(__('sidebar.payment_methods_list')); ?></a></li>
                    </ul>
                </li>


                <!-- Reports -->
                <li class="menu-group">
                    <button
                        class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                        <i class="fa-solid fa-file fa-lg text-info"></i>
                        <span><?php echo e(__('sidebar.reports')); ?></span>
                        <i class="fa-solid fa-angle-down me-auto"></i>
                    </button>

                    <ul class="submenu list-unstyled ms-4 mt-1">
                        <li><a href="<?php echo e(route('reports.service-invoices')); ?>"
                                class="submenu-item"><?php echo e(__('dashboard.invoice_report')); ?></a></li>

                        <li><a href="<?php echo e(route('reports.subscriptions')); ?>"
                                class="submenu-item"><?php echo e(__('dashboard.subscriptions_report')); ?></a>
                        </li>
                    </ul>
                </li>





                <!-- Users -->
                <li class="menu-group">
                    <button
                        class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                        <i class="fa-solid fa-user-shield fa-lg text-warning"></i>
                        <span><?php echo e(__('sidebar.users_permissions')); ?></span>
                        <i class="fa-solid fa-angle-down me-auto"></i>
                    </button>

                    <ul class="submenu list-unstyled ms-4 mt-1">
                        <li><a href="<?php echo e(route('roles.index')); ?>" class="submenu-item"><?php echo e(__('sidebar.roles')); ?></a></li>
                        <li><a href="<?php echo e(route('users.index')); ?>" class="submenu-item"><?php echo e(__('sidebar.users_list')); ?></a>
                        </li>
                    </ul>
                </li>

            </ul>
        </nav>
    </aside>
<?php endif; ?>




<?php if(auth()->guard('member')->check()): ?>
    <aside class="page-sidebar  text-white shadow h-100">

        <nav class="sidebar-menu mt-3">
            <ul class="list-unstyled px-2">

                <li class="mb-2">
                    <a href="<?php echo e(route('member.dashboard')); ?>"
                        class="d-flex align-items-center gap-3 text-white py-2 px-3 rounded hover-item">
                        <i class="fa-solid fa-house"></i>
                        <span><?php echo e(__('dashboard.dashboard')); ?></span>
                    </a>
                </li>

                <li class="mb-2">
                    <a href="<?php echo e(route('member.profile')); ?>"
                        class="d-flex align-items-center gap-3 text-white py-2 px-3 rounded hover-item">
                        <i class="fa-solid fa-user"></i>
                        <span><?php echo e(__('dashboard.profile')); ?></span>
                    </a>
                </li>

                <li class="mb-2">
                    <a href="<?php echo e(route('member.subscriptions')); ?>"
                        class="d-flex align-items-center gap-3 text-white py-2 px-3 rounded hover-item">
                        <i class="fa-solid fa-id-card"></i>
                        <span><?php echo e(__('nav.subscriptions')); ?></span>
                    </a>
                </li>

                <li class="mt-3">
                    <form method="POST" action="<?php echo e(route('member.logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-danger w-100">
                            <i class="fa-solid fa-right-from-bracket"></i>
                            <?php echo e(__('member.logout')); ?>

                        </button>
                    </form>
                </li>

            </ul>
        </nav>
    </aside>
<?php endif; ?>



<style>
    /* Sidebar Base */
    .sidebar {
        width: 270px;
        transition: all 0.3s ease;
        overflow-y: auto;
        z-index: 1000;
    }

    .sidebar.collapsed {
        width: 80px;
    }

    .hover-item:hover {
        background: rgba(255, 255, 255, 0.1);
        transition: 0.3s;
    }

    /* Submenu */
    .submenu {
        display: none;
        padding-right: 5px;
        transition: all 0.3s ease;
    }

    .submenu-item {
        display: block;
        color: #bbb;
        padding: 6px 10px;
        text-decoration: none;
        border-radius: 6px;
        font-size: 14px;
    }

    .submenu-item:hover {
        background: rgba(255, 255, 255, 0.1);
        color: #fff;
    }

    .menu-group.open>.submenu {
        display: block;
        animation: fadeIn 0.3s;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Toggle submenus
        document.querySelectorAll('.toggle-submenu').forEach(btn => {
            btn.addEventListener('click', function() {
                const parent = this.closest('.menu-group');
                parent.classList.toggle('open');
                this.querySelector('i.fa-angle-down').classList.toggle('fa-rotate-180');
            });
        });

        // Collapse sidebar
        document.getElementById('toggleSidebar').addEventListener('click', () => {
            document.getElementById('sidebar').classList.toggle('collapsed');
        });
    });
</script>
<?php /**PATH E:\xampp\htdocs\shapooov\resources\views/layouts/sidebar.blade.php ENDPATH**/ ?>